/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import net.md_5.bungee.protocol.DefinedPacket;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private final byte[] buffer = new byte[8192];
    private final Deflater deflater = new Deflater();
    private int threshold = 256;

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int origSize = msg.readableBytes();
        if (origSize < this.threshold) {
            DefinedPacket.writeVarInt(0, out);
            out.writeBytes(msg);
        } else {
            byte[] data = new byte[origSize];
            msg.readBytes(data);
            DefinedPacket.writeVarInt(data.length, out);
            this.deflater.setInput(data);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int count = this.deflater.deflate(this.buffer);
                out.writeBytes(this.buffer, 0, count);
            }
            this.deflater.reset();
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

