/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.tab.CustomTabList;
import net.md_5.bungee.api.tab.TabListAdapter;
import net.md_5.bungee.protocol.packet.PlayerListItem;

public class Custom
extends TabListAdapter
implements CustomTabList {
    private static final int ROWS = 20;
    private static final int COLUMNS = 3;
    private static final char[] FILLER = new char[]{'0', '1', '2', '2', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int MAX_LEN = 16;
    private final Collection<String> sentStuff = new HashSet<String>();
    private final String[][] sent = new String[20][3];
    private final String[][] slots = new String[20][3];
    private int rowLim;
    private int colLim;

    public Custom(ProxiedPlayer player) {
        this.init(player);
    }

    @Override
    public synchronized String setSlot(int row, int column, String text) {
        return this.setSlot(row, column, text, true);
    }

    @Override
    public synchronized String setSlot(int row, int column, String text, boolean update) {
        Preconditions.checkArgument(row > 0 && row <= 20, "row out of range");
        Preconditions.checkArgument(column > 0 && column <= 3, "column out of range");
        if (text != null) {
            Preconditions.checkArgument(text.length() <= 14, "text must be <= %s chars", 14);
            Preconditions.checkArgument(!ChatColor.stripColor(text).isEmpty(), "Text cannot consist entirely of colour codes");
            text = this.attempt(text);
            this.sentStuff.add(text);
            if (this.rowLim < row || this.colLim < column) {
                this.rowLim = row;
                this.colLim = column;
            }
        }
        this.slots[--row][--column] = text;
        if (update) {
            this.update();
        }
        return text;
    }

    private String attempt(String s) {
        for (char c : FILLER) {
            String attempt = s + Character.toString('\u00a7') + c;
            if (this.sentStuff.contains(attempt)) continue;
            return attempt;
        }
        if (s.length() <= 12) {
            return this.attempt(s + Character.toString('\u00a7') + FILLER[0]);
        }
        throw new IllegalArgumentException("List already contains all variants of string");
    }

    @Override
    public synchronized void update() {
        this.clear();
        for (int i = 0; i < this.rowLim; ++i) {
            for (int j = 0; j < this.colLim; ++j) {
                String text;
                this.sent[i][j] = text = this.slots[i][j] != null ? this.slots[i][j] : "" + Custom.base(i) + Custom.base(j);
                this.getPlayer().unsafe().sendPacket(new PlayerListItem(text, true, 0));
            }
        }
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < this.rowLim; ++i) {
            for (int j = 0; j < this.colLim; ++j) {
                if (this.sent[i][j] == null) continue;
                String text = this.sent[i][j];
                this.sent[i][j] = null;
                this.getPlayer().unsafe().sendPacket(new PlayerListItem(text, false, 9999));
            }
        }
    }

    @Override
    public synchronized int getRows() {
        return 20;
    }

    @Override
    public synchronized int getColumns() {
        return 3;
    }

    @Override
    public synchronized int getSize() {
        return 60;
    }

    @Override
    public boolean onListUpdate(String name, boolean online, int ping) {
        return false;
    }

    private static char[] base(int n) {
        String hex = Integer.toHexString(n + 1);
        char[] alloc = new char[hex.length() * 2];
        for (int i = 0; i < alloc.length; ++i) {
            alloc[i] = i % 2 == 0 ? 167 : hex.charAt(i / 2);
        }
        return alloc;
    }
}

