/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.plugin;

import java.io.InputStream;
import java.lang.reflect.Field;
import net.md_5.bungee.plugin.InvalidPluginException;
import org.yaml.snakeyaml.Yaml;

public class PluginDescription {
    private String name;
    private String main;
    private String version;
    private String author;

    private PluginDescription() {
    }

    public static PluginDescription load(InputStream is) {
        PluginDescription ret = new Yaml().loadAs(is, PluginDescription.class);
        if (ret == null) {
            throw new InvalidPluginException("Could not load plugin description file.");
        }
        for (Field f : PluginDescription.class.getDeclaredFields()) {
            try {
                if (f.get(ret) != null) continue;
                throw new InvalidPluginException(f.getName() + " is not set properly in plugin description");
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public String getMain() {
        return this.main;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMain(String main) {
        this.main = main;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDescription)) {
            return false;
        }
        PluginDescription other = (PluginDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$main = this.getMain();
        String other$main = other.getMain();
        if (this$main == null ? other$main != null : !this$main.equals(other$main)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        return !(this$author == null ? other$author != null : !this$author.equals(other$author));
    }

    public boolean canEqual(Object other) {
        return other instanceof PluginDescription;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        String $main = this.getMain();
        result = result * 31 + ($main == null ? 0 : $main.hashCode());
        String $version = this.getVersion();
        result = result * 31 + ($version == null ? 0 : $version.hashCode());
        String $author = this.getAuthor();
        result = result * 31 + ($author == null ? 0 : $author.hashCode());
        return result;
    }

    public String toString() {
        return "PluginDescription(name=" + this.getName() + ", main=" + this.getMain() + ", version=" + this.getVersion() + ", author=" + this.getAuthor() + ")";
    }
}

