/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.InstantMobEffect;

public class MobEffectList {
    public static final MobEffectList[] byId = new MobEffectList[32];
    public static final MobEffectList b = null;
    public static final MobEffectList FASTER_MOVEMENT = new MobEffectList(1, false, 8171462).b("potion.moveSpeed").b(0, 0);
    public static final MobEffectList SLOWER_MOVEMENT = new MobEffectList(2, true, 5926017).b("potion.moveSlowdown").b(1, 0);
    public static final MobEffectList FASTER_DIG = new MobEffectList(3, false, 14270531).b("potion.digSpeed").b(2, 0).a(1.5);
    public static final MobEffectList SLOWER_DIG = new MobEffectList(4, true, 4866583).b("potion.digSlowDown").b(3, 0);
    public static final MobEffectList INCREASE_DAMAGE = new MobEffectList(5, false, 9643043).b("potion.damageBoost").b(4, 0);
    public static final MobEffectList HEAL = new InstantMobEffect(6, false, 16262179).b("potion.heal");
    public static final MobEffectList HARM = new InstantMobEffect(7, true, 4393481).b("potion.harm");
    public static final MobEffectList JUMP = new MobEffectList(8, false, 7889559).b("potion.jump").b(2, 1);
    public static final MobEffectList CONFUSION = new MobEffectList(9, true, 5578058).b("potion.confusion").b(3, 1).a(0.25);
    public static final MobEffectList REGENERATION = new MobEffectList(10, false, 13458603).b("potion.regeneration").b(7, 0).a(0.25);
    public static final MobEffectList RESISTANCE = new MobEffectList(11, false, 10044730).b("potion.resistance").b(6, 1);
    public static final MobEffectList FIRE_RESISTANCE = new MobEffectList(12, false, 14981690).b("potion.fireResistance").b(7, 1);
    public static final MobEffectList WATER_BREATHING = new MobEffectList(13, false, 3035801).b("potion.waterBreathing").b(0, 2);
    public static final MobEffectList INVISIBILITY = new MobEffectList(14, false, 8356754).b("potion.invisibility").b(0, 1).h();
    public static final MobEffectList BLINDNESS = new MobEffectList(15, true, 2039587).b("potion.blindness").b(5, 1).a(0.25);
    public static final MobEffectList NIGHT_VISION = new MobEffectList(16, false, 0x1F1FA1).b("potion.nightVision").b(4, 1).h();
    public static final MobEffectList HUNGER = new MobEffectList(17, true, 5797459).b("potion.hunger").b(1, 1);
    public static final MobEffectList WEAKNESS = new MobEffectList(18, true, 0x484D48).b("potion.weakness").b(5, 0);
    public static final MobEffectList POISON = new MobEffectList(19, true, 5149489).b("potion.poison").b(6, 0).a(0.25);
    public static final MobEffectList v = null;
    public static final MobEffectList w = null;
    public static final MobEffectList x = null;
    public static final MobEffectList y = null;
    public static final MobEffectList z = null;
    public static final MobEffectList A = null;
    public static final MobEffectList B = null;
    public static final MobEffectList C = null;
    public static final MobEffectList D = null;
    public static final MobEffectList E = null;
    public static final MobEffectList F = null;
    public static final MobEffectList G = null;
    public final int id;
    private String I = "";
    private int J = -1;
    private final boolean K;
    private double L;
    private boolean M;
    private final int N;

    protected MobEffectList(int n, boolean bl, int n2) {
        this.id = n;
        MobEffectList.byId[n] = this;
        this.K = bl;
        this.L = bl ? 0.5 : 1.0;
        this.N = n2;
    }

    protected MobEffectList b(int n, int n2) {
        this.J = n + n2 * 8;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public void tick(EntityLiving entityLiving, int n) {
        if (this.id == MobEffectList.REGENERATION.id) {
            if (entityLiving.getHealth() < entityLiving.getMaxHealth()) {
                entityLiving.heal(1);
            }
        } else if (this.id == MobEffectList.POISON.id) {
            if (entityLiving.getHealth() > 1) {
                entityLiving.damageEntity(DamageSource.MAGIC, 1);
            }
        } else if (this.id == MobEffectList.HUNGER.id && entityLiving instanceof EntityHuman) {
            ((EntityHuman)entityLiving).j(0.025f * (float)(n + 1));
        } else if (this.id == MobEffectList.HEAL.id && !entityLiving.br() || this.id == MobEffectList.HARM.id && entityLiving.br()) {
            entityLiving.heal(6 << n);
        } else if (this.id == MobEffectList.HARM.id && !entityLiving.br() || this.id == MobEffectList.HEAL.id && entityLiving.br()) {
            entityLiving.damageEntity(DamageSource.MAGIC, 6 << n);
        }
    }

    public void applyInstantEffect(EntityLiving entityLiving, EntityLiving entityLiving2, int n, double d) {
        if (this.id == MobEffectList.HEAL.id && !entityLiving2.br() || this.id == MobEffectList.HARM.id && entityLiving2.br()) {
            int n2 = (int)(d * (double)(6 << n) + 0.5);
            entityLiving2.heal(n2);
        } else if (this.id == MobEffectList.HARM.id && !entityLiving2.br() || this.id == MobEffectList.HEAL.id && entityLiving2.br()) {
            int n3 = (int)(d * (double)(6 << n) + 0.5);
            if (entityLiving == null) {
                entityLiving2.damageEntity(DamageSource.MAGIC, n3);
            } else {
                entityLiving2.damageEntity(DamageSource.b(entityLiving2, entityLiving), n3);
            }
        }
    }

    public boolean isInstant() {
        return false;
    }

    public boolean a(int n, int n2) {
        if (this.id == MobEffectList.REGENERATION.id || this.id == MobEffectList.POISON.id) {
            int n3 = 25 >> n2;
            if (n3 > 0) {
                return n % n3 == 0;
            }
            return true;
        }
        return this.id == MobEffectList.HUNGER.id;
    }

    public MobEffectList b(String string) {
        this.I = string;
        return this;
    }

    public String a() {
        return this.I;
    }

    protected MobEffectList a(double d) {
        this.L = d;
        return this;
    }

    public double getDurationModifier() {
        return this.L;
    }

    public MobEffectList h() {
        this.M = true;
        return this;
    }

    public boolean i() {
        return this.M;
    }

    public int j() {
        return this.N;
    }
}

