/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockSand;
import net.minecraft.server.Entity;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityFallingBlock
extends Entity {
    public int id;
    public int data;
    public int c = 0;
    public boolean dropItem = true;

    public EntityFallingBlock(World world) {
        super(world);
    }

    public EntityFallingBlock(World world, double d, double d2, double d3, int n) {
        this(world, d, d2, d3, n, 0);
    }

    public EntityFallingBlock(World world, double d, double d2, double d3, int n, int n2) {
        super(world);
        this.id = n;
        this.data = n2;
        this.m = true;
        this.a(0.98f, 0.98f);
        this.height = this.length / 2.0f;
        this.setPosition(d, d2, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    protected boolean e_() {
        return false;
    }

    protected void a() {
    }

    public boolean L() {
        return !this.dead;
    }

    public void h_() {
        if (this.id == 0) {
            this.die();
            return;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        ++this.c;
        this.motY -= (double)0.04f;
        this.move(this.motX, this.motY, this.motZ);
        this.motX *= (double)0.98f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)0.98f;
        if (!this.world.isStatic) {
            int n = MathHelper.floor(this.locX);
            int n2 = MathHelper.floor(this.locY);
            int n3 = MathHelper.floor(this.locZ);
            if (this.c == 1) {
                if (this.c == 1 && this.world.getTypeId(n, n2, n3) == this.id) {
                    this.world.setTypeId(n, n2, n3, 0);
                } else {
                    this.die();
                }
            }
            if (this.onGround) {
                this.motX *= (double)0.7f;
                this.motZ *= (double)0.7f;
                this.motY *= -0.5;
                if (this.world.getTypeId(n, n2, n3) != Block.PISTON_MOVING.id) {
                    this.die();
                    if (!(this.world.mayPlace(this.id, n, n2, n3, true, 1, null) && !BlockSand.canFall(this.world, n, n2 - 1, n3) && this.world.setTypeIdAndData(n, n2, n3, this.id, this.data) || this.world.isStatic || !this.dropItem)) {
                        this.a(new ItemStack(this.id, 1, this.data), 0.0f);
                    }
                }
            } else if (this.c > 100 && !this.world.isStatic && (n2 < 1 || n2 > 256) || this.c > 600) {
                if (this.dropItem) {
                    this.b(this.id, 1);
                }
                this.die();
            }
        }
    }

    protected void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("Tile", (byte)this.id);
        nBTTagCompound.setByte("Data", (byte)this.data);
        nBTTagCompound.setByte("Time", (byte)this.c);
        nBTTagCompound.setBoolean("DropItem", this.dropItem);
    }

    protected void a(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.getByte("Tile") & 0xFF;
        this.data = nBTTagCompound.getByte("Data") & 0xFF;
        this.c = nBTTagCompound.getByte("Time") & 0xFF;
        if (nBTTagCompound.hasKey("DropItem")) {
            this.dropItem = nBTTagCompound.getBoolean("DropItem");
        }
        if (this.id == 0) {
            this.id = Block.SAND.id;
        }
    }
}

