/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module.cmd.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class CommandServer
extends Command
implements TabExecutor {
    public CommandServer() {
        super("server", "bungeecord.command.server", new String[0]);
    }

    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        Map servers = ProxyServer.getInstance().getServers();
        if (args.length == 0) {
            player.sendMessage(ProxyServer.getInstance().getTranslation("current_server", new Object[0]) + player.getServer().getInfo().getName());
            TextComponent serverList = new TextComponent(ProxyServer.getInstance().getTranslation("server_list", new Object[0]));
            serverList.setColor(ChatColor.GOLD);
            boolean first = true;
            for (ServerInfo server : servers.values()) {
                if (!server.canAccess((CommandSender)player)) continue;
                TextComponent serverTextComponent = new TextComponent(first ? server.getName() : ", " + server.getName());
                serverTextComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(server.getPlayers().size() + " players").create()));
                serverTextComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + server.getName()));
                serverList.addExtra((BaseComponent)serverTextComponent);
                first = false;
            }
            player.sendMessage((BaseComponent)serverList);
        } else {
            ServerInfo server = (ServerInfo)servers.get(args[0]);
            if (server == null) {
                player.sendMessage(ProxyServer.getInstance().getTranslation("no_server", new Object[0]));
            } else if (!server.canAccess((CommandSender)player)) {
                player.sendMessage(ProxyServer.getInstance().getTranslation("no_server_permission", new Object[0]));
            } else {
                player.connect(server);
            }
        }
    }

    public Iterable<String> onTabComplete(final CommandSender sender, String[] args) {
        return args.length != 0 ? Collections.EMPTY_LIST : Iterables.transform((Iterable)Iterables.filter(ProxyServer.getInstance().getServers().values(), (Predicate)new Predicate<ServerInfo>(){

            public boolean apply(ServerInfo input) {
                return input.canAccess(sender);
            }
        }), (Function)new Function<ServerInfo, String>(){

            public String apply(ServerInfo input) {
                return input.getName();
            }
        });
    }
}

