/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.DefinedPacket;

public class EntityMap {
    private final boolean[] clientboundInts = new boolean[256];
    private final boolean[] clientboundVarInts = new boolean[256];
    private final boolean[] serverboundInts = new boolean[256];
    private final boolean[] serverboundVarInts = new boolean[256];

    public EntityMap(int version) {
        this.clientboundInts[4] = true;
        this.clientboundInts[10] = true;
        this.clientboundVarInts[11] = true;
        this.clientboundVarInts[12] = true;
        this.clientboundInts[13] = true;
        this.clientboundVarInts[14] = true;
        this.clientboundVarInts[15] = true;
        this.clientboundVarInts[16] = true;
        this.clientboundVarInts[17] = true;
        this.clientboundInts[18] = true;
        this.clientboundInts[20] = true;
        this.clientboundInts[21] = true;
        this.clientboundInts[22] = true;
        this.clientboundInts[23] = true;
        this.clientboundInts[24] = true;
        this.clientboundInts[25] = true;
        this.clientboundInts[26] = true;
        this.clientboundInts[27] = true;
        this.clientboundInts[28] = true;
        this.clientboundInts[29] = true;
        this.clientboundInts[30] = true;
        this.clientboundInts[32] = true;
        this.clientboundVarInts[37] = true;
        this.clientboundVarInts[44] = true;
        this.serverboundInts[2] = true;
        this.serverboundInts[10] = true;
        this.serverboundInts[11] = true;
        if (version >= 7) {
            this.migrateIntToVarint(this.clientboundInts, this.clientboundVarInts);
            this.migrateIntToVarint(this.serverboundInts, this.serverboundVarInts);
        }
    }

    private void migrateIntToVarint(boolean[] ints, boolean[] varints) {
        for (int i = 0; i < ints.length; ++i) {
            if (!ints[i]) continue;
            varints[i] = true;
            ints[i] = false;
        }
    }

    public void rewriteServerbound(ByteBuf packet, int serverEntityId, int clientEntityId) {
        EntityMap.rewrite(packet, serverEntityId, clientEntityId, this.serverboundInts, this.serverboundVarInts);
    }

    public void rewriteClientbound(ByteBuf packet, int serverEntityId, int clientEntityId) {
        EntityMap.rewrite(packet, serverEntityId, clientEntityId, this.clientboundInts, this.clientboundVarInts);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 13 || packetId == 27) {
            int readId = packet.getInt(packetIdLength + 4);
            if (readId == serverEntityId) {
                packet.setInt(packetIdLength + 4, clientEntityId);
            } else if (readId == clientEntityId) {
                packet.setInt(packetIdLength + 4, serverEntityId);
            }
        } else if (packetId == 19) {
            int count = packet.getByte(packetIdLength);
            for (int i = 0; i < count; ++i) {
                int readId = packet.getInt(packetIdLength + 1 + i * 4);
                if (readId == serverEntityId) {
                    packet.setInt(packetIdLength + 1 + i * 4, clientEntityId);
                    continue;
                }
                if (readId != clientEntityId) continue;
                packet.setInt(packetIdLength + 1 + i * 4, serverEntityId);
            }
        } else if (packetId == 14) {
            DefinedPacket.readVarInt(packet);
            int idLength = packet.readerIndex() - readerIndex - packetIdLength;
            byte type = packet.getByte(packetIdLength + idLength);
            if (type == 60 || type == 90) {
                int readId = packet.getInt(packetIdLength + idLength + 15);
                if (readId == serverEntityId) {
                    packet.setInt(packetIdLength + idLength + 15, clientEntityId);
                } else if (readId == clientEntityId) {
                    packet.setInt(packetIdLength + idLength + 15, serverEntityId);
                }
            }
        }
        packet.readerIndex(readerIndex);
    }

    private static void rewrite(ByteBuf packet, int serverEntityId, int clientEntityId, boolean[] ints, boolean[] varints) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (ints[packetId]) {
            int readId = packet.getInt(packetIdLength);
            if (readId == serverEntityId) {
                packet.setInt(packetIdLength, clientEntityId);
            } else if (readId == clientEntityId) {
                packet.setInt(packetIdLength, serverEntityId);
            }
        } else if (varints[packetId]) {
            int readId = DefinedPacket.readVarInt(packet);
            int readIdLength = packet.readerIndex() - readerIndex - packetIdLength;
            if (readId == serverEntityId || readId == clientEntityId) {
                ByteBuf data = packet.slice().copy();
                packet.readerIndex(readerIndex);
                packet.writerIndex(packetIdLength);
                DefinedPacket.writeVarInt(readId == serverEntityId ? clientEntityId : serverEntityId, packet);
                packet.writeBytes(data);
                data.release();
            }
        }
        packet.readerIndex(readerIndex);
    }
}

