/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;

public class Team
extends DefinedPacket {
    private String name;
    private byte mode;
    private String displayName;
    private String prefix;
    private String suffix;
    private boolean friendlyFire;
    private short playerCount;
    private String[] players;

    public Team(String name) {
        this();
        this.name = name;
        this.mode = 1;
    }

    @Override
    public void read(ByteBuf buf, Protocol.ProtocolDirection direction, int protocolVersion) {
        this.name = Team.readString(buf);
        this.mode = buf.readByte();
        if (this.mode == 0 || this.mode == 2) {
            this.displayName = Team.readString(buf);
            this.prefix = Team.readString(buf);
            this.suffix = Team.readString(buf);
            this.friendlyFire = buf.readBoolean();
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            int len = protocolVersion >= 7 ? Team.readVarInt(buf) : (int)buf.readShort();
            this.players = new String[len];
            for (int i = 0; i < len; ++i) {
                this.players[i] = Team.readString(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, Protocol.ProtocolDirection direction, int protocolVersion) {
        Team.writeString(this.name, buf);
        buf.writeByte(this.mode);
        if (this.mode == 0 || this.mode == 2) {
            Team.writeString(this.displayName, buf);
            Team.writeString(this.prefix, buf);
            Team.writeString(this.suffix, buf);
            buf.writeBoolean(this.friendlyFire);
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            if (protocolVersion >= 7) {
                Team.writeVarInt(this.players.length, buf);
            } else {
                buf.writeShort(this.players.length);
            }
            for (String player : this.players) {
                Team.writeString(player, buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getName() {
        return this.name;
    }

    public byte getMode() {
        return this.mode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public short getPlayerCount() {
        return this.playerCount;
    }

    public String[] getPlayers() {
        return this.players;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    public void setPlayerCount(short playerCount) {
        this.playerCount = playerCount;
    }

    public void setPlayers(String[] players) {
        this.players = players;
    }

    @Override
    public String toString() {
        return "Team(name=" + this.getName() + ", mode=" + this.getMode() + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", friendlyFire=" + this.isFriendlyFire() + ", playerCount=" + this.getPlayerCount() + ", players=" + Arrays.deepToString(this.getPlayers()) + ")";
    }

    public Team() {
    }

    @ConstructorProperties(value={"name", "mode", "displayName", "prefix", "suffix", "friendlyFire", "playerCount", "players"})
    public Team(String name, byte mode, String displayName, String prefix, String suffix, boolean friendlyFire, short playerCount, String[] players) {
        this.name = name;
        this.mode = mode;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.playerCount = playerCount;
        this.players = players;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team other = (Team)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        if (this.isFriendlyFire() != other.isFriendlyFire()) {
            return false;
        }
        if (this.getPlayerCount() != other.getPlayerCount()) {
            return false;
        }
        return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
    }

    public boolean canEqual(Object other) {
        return other instanceof Team;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        result = result * 31 + this.getMode();
        String $displayName = this.getDisplayName();
        result = result * 31 + ($displayName == null ? 0 : $displayName.hashCode());
        String $prefix = this.getPrefix();
        result = result * 31 + ($prefix == null ? 0 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 31 + ($suffix == null ? 0 : $suffix.hashCode());
        result = result * 31 + (this.isFriendlyFire() ? 1231 : 1237);
        result = result * 31 + this.getPlayerCount();
        result = result * 31 + Arrays.deepHashCode(this.getPlayers());
        return result;
    }
}

