/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class ChannelWrapper {
    private final Channel ch;
    private volatile boolean closed;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
    }

    public void setProtocol(Protocol protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocol(protocol);
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocol(protocol);
    }

    public void setVersion(int protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocolVersion(protocol);
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocolVersion(protocol);
    }

    public synchronized void write(Object packet) {
        if (!this.closed) {
            if (packet instanceof PacketWrapper) {
                ((PacketWrapper)packet).setReleased(true);
                this.ch.write(((PacketWrapper)packet).buf, this.ch.voidPromise());
            } else {
                this.ch.write(packet, this.ch.voidPromise());
            }
            this.ch.flush();
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.ch.flush();
            this.ch.close();
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

