/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import net.md_5.bungee.Util;

public abstract class DefinedPacket
implements DataInput,
DataOutput {
    private ByteArrayDataInput in;
    private ByteArrayDataOutput out;
    public final int id;
    private byte[] packet;

    public DefinedPacket(int id, byte[] buf) {
        this.in = ByteStreams.newDataInput(buf);
        if (this.readUnsignedByte() != id) {
            throw new IllegalArgumentException("Wasn't expecting packet id " + Util.hex(id));
        }
        this.id = id;
        this.packet = buf;
    }

    public DefinedPacket(int id) {
        this.out = ByteStreams.newDataOutput();
        this.id = id;
        this.writeByte(id);
    }

    public byte[] getPacket() {
        return this.packet == null ? this.out.toByteArray() : this.packet;
    }

    @Override
    public void writeUTF(String s) {
        this.writeShort(s.length());
        this.writeChars(s);
    }

    @Override
    public String readUTF() {
        int len = this.readShort();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    public void writeArray(byte[] b) {
        this.writeShort(b.length);
        this.write(b);
    }

    public byte[] readArray() {
        short len = this.readShort();
        byte[] ret = new byte[len];
        this.readFully(ret);
        return ret;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Override
    public void readFully(byte[] arg0) {
        this.in.readFully(arg0);
    }

    @Override
    public void readFully(byte[] arg0, int arg1, int arg2) {
        this.in.readFully(arg0, arg1, arg2);
    }

    @Override
    public int skipBytes(int arg0) {
        return this.in.skipBytes(arg0);
    }

    @Override
    public boolean readBoolean() {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() {
        return this.in.readChar();
    }

    @Override
    public int readInt() {
        return this.in.readInt();
    }

    @Override
    public long readLong() {
        return this.in.readLong();
    }

    @Override
    public float readFloat() {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() {
        return this.in.readDouble();
    }

    @Override
    public String readLine() {
        return this.in.readLine();
    }

    @Override
    public void write(int arg0) {
        this.out.write(arg0);
    }

    @Override
    public void write(byte[] arg0) {
        this.out.write(arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        this.out.write(arg0, arg1, arg2);
    }

    @Override
    public void writeBoolean(boolean arg0) {
        this.out.writeBoolean(arg0);
    }

    @Override
    public void writeByte(int arg0) {
        this.out.writeByte(arg0);
    }

    @Override
    public void writeShort(int arg0) {
        this.out.writeShort(arg0);
    }

    @Override
    public void writeChar(int arg0) {
        this.out.writeChar(arg0);
    }

    @Override
    public void writeInt(int arg0) {
        this.out.writeInt(arg0);
    }

    @Override
    public void writeLong(long arg0) {
        this.out.writeLong(arg0);
    }

    @Override
    public void writeFloat(float arg0) {
        this.out.writeFloat(arg0);
    }

    @Override
    public void writeDouble(double arg0) {
        this.out.writeDouble(arg0);
    }

    @Override
    public void writeChars(String arg0) {
        this.out.writeChars(arg0);
    }

    @Override
    @Deprecated
    public void writeBytes(String arg0) {
        this.out.writeBytes(arg0);
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    private static interface Overriden {
        public void readUTF();

        public void writeUTF(String var1);
    }
}

