/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.DefinedPacket;

public class EntityMap {
    private static final boolean[] clientboundInts = new boolean[256];
    private static final boolean[] clientboundVarInts = new boolean[256];
    private static final boolean[] serverboundInts = new boolean[256];
    private static final boolean[] serverboundVarInts = new boolean[256];

    public static void rewriteServerbound(ByteBuf packet, int serverEntityId, int clientEntityId) {
        EntityMap.rewrite(packet, serverEntityId, clientEntityId, serverboundInts, serverboundVarInts);
    }

    public static void rewriteClientbound(ByteBuf packet, int serverEntityId, int clientEntityId) {
        EntityMap.rewrite(packet, serverEntityId, clientEntityId, clientboundInts, clientboundVarInts);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 13 || packetId == 27) {
            int readId = packet.getInt(packetIdLength + 4);
            if (readId == serverEntityId) {
                packet.setInt(packetIdLength + 4, clientEntityId);
            } else if (readId == clientEntityId) {
                packet.setInt(packetIdLength + 4, serverEntityId);
            }
        } else if (packetId == 19) {
            int count = packet.getByte(packetIdLength);
            for (int i = 0; i < count; ++i) {
                int readId = packet.getInt(packetIdLength + 1 + i * 4);
                if (readId == serverEntityId) {
                    packet.setInt(packetIdLength + 1 + i * 4, clientEntityId);
                    continue;
                }
                if (readId != clientEntityId) continue;
                packet.setInt(packetIdLength + 1 + i * 4, serverEntityId);
            }
        } else if (packetId == 14) {
            DefinedPacket.readVarInt(packet);
            int idLength = packet.readerIndex() - readerIndex - packetIdLength;
            byte type = packet.getByte(packetIdLength + idLength);
            if (type == 60 || type == 90) {
                int readId = packet.getInt(packetIdLength + idLength + 15);
                if (readId == serverEntityId) {
                    packet.setInt(packetIdLength + idLength + 15, clientEntityId);
                } else if (readId == clientEntityId) {
                    packet.setInt(packetIdLength + idLength + 15, serverEntityId);
                }
            }
        }
        packet.readerIndex(readerIndex);
    }

    private static void rewrite(ByteBuf packet, int serverEntityId, int clientEntityId, boolean[] ints, boolean[] varints) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (ints[packetId]) {
            int readId = packet.getInt(packetIdLength);
            if (readId == serverEntityId) {
                packet.setInt(packetIdLength, clientEntityId);
            } else if (readId == clientEntityId) {
                packet.setInt(packetIdLength, serverEntityId);
            }
        } else if (varints[packetId]) {
            int readId = DefinedPacket.readVarInt(packet);
            int readIdLength = packet.readerIndex() - readerIndex - packetIdLength;
            if (readId == serverEntityId || readId == clientEntityId) {
                ByteBuf data = packet.slice().copy();
                packet.readerIndex(readerIndex);
                packet.writerIndex(packetIdLength);
                DefinedPacket.writeVarInt(readId == serverEntityId ? clientEntityId : serverEntityId, packet);
                packet.writeBytes(data);
                data.release();
            }
        }
        packet.readerIndex(readerIndex);
    }

    static {
        EntityMap.clientboundInts[4] = true;
        EntityMap.clientboundInts[10] = true;
        EntityMap.clientboundVarInts[11] = true;
        EntityMap.clientboundVarInts[12] = true;
        EntityMap.clientboundInts[13] = true;
        EntityMap.clientboundVarInts[14] = true;
        EntityMap.clientboundVarInts[15] = true;
        EntityMap.clientboundVarInts[16] = true;
        EntityMap.clientboundVarInts[17] = true;
        EntityMap.clientboundInts[18] = true;
        EntityMap.clientboundInts[20] = true;
        EntityMap.clientboundInts[21] = true;
        EntityMap.clientboundInts[22] = true;
        EntityMap.clientboundInts[23] = true;
        EntityMap.clientboundInts[24] = true;
        EntityMap.clientboundInts[25] = true;
        EntityMap.clientboundInts[26] = true;
        EntityMap.clientboundInts[27] = true;
        EntityMap.clientboundInts[28] = true;
        EntityMap.clientboundInts[29] = true;
        EntityMap.clientboundInts[30] = true;
        EntityMap.clientboundInts[32] = true;
        EntityMap.clientboundVarInts[37] = true;
        EntityMap.clientboundVarInts[44] = true;
        EntityMap.serverboundInts[2] = true;
        EntityMap.serverboundInts[10] = true;
        EntityMap.serverboundInts[11] = true;
    }
}

