/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import gnu.trove.map.TMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.md_5.bungee.util.CaseInsensitiveSet;

public class Configuration
implements ProxyConfig {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private TMap<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private int playerLimit = -1;
    private Collection<String> disabledCommands;
    private int throttle = 4000;
    private boolean ipFoward;
    public String favicon;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        File fav = new File("server-icon.png");
        if (fav.exists()) {
            try {
                this.favicon = "data:image/png;base64," + BaseEncoding.base64().encode(Files.toByteArray(fav));
            }
            catch (IOException ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load server icon", ex);
            }
        }
        this.listeners = adapter.getListeners();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.playerLimit = adapter.getInt("player_limit", this.playerLimit);
        this.throttle = adapter.getInt("connection_throttle", this.throttle);
        this.ipFoward = adapter.getBoolean("ip_forward", this.ipFoward);
        this.disabledCommands = new CaseInsensitiveSet(adapter.getList("disabled_commands", Arrays.asList("find")));
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        Map<String, ServerInfo> newServers = adapter.getServers();
        Preconditions.checkArgument(newServers != null && !newServers.isEmpty(), "No servers defined");
        if (this.servers == null) {
            this.servers = new CaseInsensitiveMap<ServerInfo>(newServers);
        } else {
            for (ServerInfo serverInfo : this.servers.values()) {
                Preconditions.checkArgument(newServers.containsValue(serverInfo), "Server %s removed on reload!", serverInfo.getName());
            }
            for (Map.Entry entry : newServers.entrySet()) {
                if (this.servers.containsValue(entry.getValue())) continue;
                this.servers.put((String)entry.getKey(), (ServerInfo)entry.getValue());
            }
        }
        for (ListenerInfo listenerInfo : this.listeners) {
            Preconditions.checkArgument(this.servers.containsKey(listenerInfo.getDefaultServer()), "Default server %s is not defined", listenerInfo.getDefaultServer());
            Preconditions.checkArgument(this.servers.containsKey(listenerInfo.getFallbackServer()), "Fallback server %s is not defined", listenerInfo.getFallbackServer());
            for (String server : listenerInfo.getForcedHosts().values()) {
                if (this.servers.containsKey(server)) continue;
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Forced host server {0} is not defined", server);
            }
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public TMap<String, ServerInfo> getServers() {
        return this.servers;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public int getPlayerLimit() {
        return this.playerLimit;
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Override
    public int getThrottle() {
        return this.throttle;
    }

    @Override
    public boolean isIpFoward() {
        return this.ipFoward;
    }

    @Override
    public String getFavicon() {
        return this.favicon;
    }
}

