/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.server.NBTBase;

public class NBTTagDouble
extends NBTBase {
    public double data;

    public NBTTagDouble(String string) {
        super(string);
    }

    public NBTTagDouble(String string, double d) {
        super(string);
        this.data = d;
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeDouble(this.data);
    }

    void load(DataInput dataInput) {
        this.data = dataInput.readDouble();
    }

    public byte getTypeId() {
        return 6;
    }

    public String toString() {
        return "" + this.data;
    }

    public NBTBase clone() {
        return new NBTTagDouble(this.getName(), this.data);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagDouble nBTTagDouble = (NBTTagDouble)object;
            return this.data == nBTTagDouble.data;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(l ^ l >>> 32);
    }
}

