/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EnumArt;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityPainting
extends Entity {
    private int f = 0;
    public int direction = 0;
    public int x;
    public int y;
    public int z;
    public EnumArt art;

    public EntityPainting(World world) {
        super(world);
        this.height = 0.0f;
        this.a(0.5f, 0.5f);
    }

    public EntityPainting(World world, int n, int n2, int n3, int n4) {
        this(world);
        this.x = n;
        this.y = n2;
        this.z = n3;
        ArrayList<EnumArt> arrayList = new ArrayList<EnumArt>();
        EnumArt[] enumArtArray = EnumArt.values();
        int n5 = enumArtArray.length;
        for (int i = 0; i < n5; ++i) {
            EnumArt enumArt;
            this.art = enumArt = enumArtArray[i];
            this.setDirection(n4);
            if (!this.survives()) continue;
            arrayList.add(enumArt);
        }
        if (!arrayList.isEmpty()) {
            this.art = (EnumArt)((Object)arrayList.get(this.random.nextInt(arrayList.size())));
        }
        this.setDirection(n4);
    }

    protected void a() {
    }

    public void setDirection(int n) {
        this.direction = n;
        this.lastYaw = this.yaw = (float)(n * 90);
        float f = this.art.B;
        float f2 = this.art.C;
        float f3 = this.art.B;
        if (n == 0 || n == 2) {
            f3 = 0.5f;
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f2 /= 32.0f;
        f3 /= 32.0f;
        float f4 = (float)this.x + 0.5f;
        float f5 = (float)this.y + 0.5f;
        float f6 = (float)this.z + 0.5f;
        float f7 = 0.5625f;
        if (n == 0) {
            f6 -= f7;
        }
        if (n == 1) {
            f4 -= f7;
        }
        if (n == 2) {
            f6 += f7;
        }
        if (n == 3) {
            f4 += f7;
        }
        if (n == 0) {
            f4 -= this.b(this.art.B);
        }
        if (n == 1) {
            f6 += this.b(this.art.B);
        }
        if (n == 2) {
            f4 += this.b(this.art.B);
        }
        if (n == 3) {
            f6 -= this.b(this.art.B);
        }
        this.setPosition(f4, f5 += this.b(this.art.C), f6);
        float f8 = -0.00625f;
        this.boundingBox.b(f4 - f - f8, f5 - f2 - f8, f6 - f3 - f8, f4 + f + f8, f5 + f2 + f8, f6 + f3 + f8);
    }

    private float b(int n) {
        if (n == 32) {
            return 0.5f;
        }
        if (n == 64) {
            return 0.5f;
        }
        return 0.0f;
    }

    public void h_() {
        if (this.f++ == 100 && !this.world.isStatic) {
            this.f = 0;
            if (!this.dead && !this.survives()) {
                this.die();
                this.world.addEntity(new EntityItem(this.world, this.locX, this.locY, this.locZ, new ItemStack(Item.PAINTING)));
            }
        }
    }

    public boolean survives() {
        if (!this.world.getCubes(this, this.boundingBox).isEmpty()) {
            return false;
        }
        int n = this.art.B / 16;
        int n2 = this.art.C / 16;
        int n3 = this.x;
        int n4 = this.y;
        int n5 = this.z;
        if (this.direction == 0) {
            n3 = MathHelper.floor(this.locX - (double)((float)this.art.B / 32.0f));
        }
        if (this.direction == 1) {
            n5 = MathHelper.floor(this.locZ - (double)((float)this.art.B / 32.0f));
        }
        if (this.direction == 2) {
            n3 = MathHelper.floor(this.locX - (double)((float)this.art.B / 32.0f));
        }
        if (this.direction == 3) {
            n5 = MathHelper.floor(this.locZ - (double)((float)this.art.B / 32.0f));
        }
        n4 = MathHelper.floor(this.locY - (double)((float)this.art.C / 32.0f));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.direction == 0 || this.direction == 2 ? this.world.getMaterial(n3 + i, n4 + j, this.z) : this.world.getMaterial(this.x, n4 + j, n5 + i);
                if (((Material)object).isBuildable()) continue;
                return false;
            }
        }
        List list = this.world.getEntities(this, this.boundingBox);
        for (Object object : list) {
            if (!(object instanceof EntityPainting)) continue;
            return false;
        }
        return true;
    }

    public boolean L() {
        return true;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (!this.dead && !this.world.isStatic) {
            this.die();
            this.K();
            EntityHuman entityHuman = null;
            if (damageSource.getEntity() instanceof EntityHuman) {
                entityHuman = (EntityHuman)damageSource.getEntity();
            }
            if (entityHuman != null && entityHuman.abilities.canInstantlyBuild) {
                return true;
            }
            this.world.addEntity(new EntityItem(this.world, this.locX, this.locY, this.locZ, new ItemStack(Item.PAINTING)));
        }
        return true;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("Dir", (byte)this.direction);
        nBTTagCompound.setString("Motive", this.art.A);
        nBTTagCompound.setInt("TileX", this.x);
        nBTTagCompound.setInt("TileY", this.y);
        nBTTagCompound.setInt("TileZ", this.z);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.direction = nBTTagCompound.getByte("Dir");
        this.x = nBTTagCompound.getInt("TileX");
        this.y = nBTTagCompound.getInt("TileY");
        this.z = nBTTagCompound.getInt("TileZ");
        String string = nBTTagCompound.getString("Motive");
        for (EnumArt enumArt : EnumArt.values()) {
            if (!enumArt.A.equals(string)) continue;
            this.art = enumArt;
        }
        if (this.art == null) {
            this.art = EnumArt.KEBAB;
        }
        this.setDirection(this.direction);
    }

    public void move(double d, double d2, double d3) {
        if (!this.world.isStatic && !this.dead && d * d + d2 * d2 + d3 * d3 > 0.0) {
            this.die();
            this.world.addEntity(new EntityItem(this.world, this.locX, this.locY, this.locZ, new ItemStack(Item.PAINTING)));
        }
    }

    public void g(double d, double d2, double d3) {
        if (!this.world.isStatic && !this.dead && d * d + d2 * d2 + d3 * d3 > 0.0) {
            this.die();
            this.world.addEntity(new EntityItem(this.world, this.locX, this.locY, this.locZ, new ItemStack(Item.PAINTING)));
        }
    }
}

