/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentInstance;
import net.minecraft.server.EnchantmentModifier;
import net.minecraft.server.EnchantmentModifierDamage;
import net.minecraft.server.EnchantmentModifierProtection;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.WeightedRandom;

public class EnchantmentManager {
    private static final Random random = new Random();
    private static final EnchantmentModifierProtection b = new EnchantmentModifierProtection(null);
    private static final EnchantmentModifierDamage c = new EnchantmentModifierDamage(null);

    public static int getEnchantmentLevel(int n, ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        NBTTagList nBTTagList = itemStack.getEnchantments();
        if (nBTTagList == null) {
            return 0;
        }
        for (int i = 0; i < nBTTagList.size(); ++i) {
            short s = ((NBTTagCompound)nBTTagList.get(i)).getShort("id");
            short s2 = ((NBTTagCompound)nBTTagList.get(i)).getShort("lvl");
            if (s != n) continue;
            return s2;
        }
        return 0;
    }

    private static int getEnchantmentLevel(int n, ItemStack[] itemStackArray) {
        int n2 = 0;
        for (ItemStack itemStack : itemStackArray) {
            int n3 = EnchantmentManager.getEnchantmentLevel(n, itemStack);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static void a(EnchantmentModifier enchantmentModifier, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        NBTTagList nBTTagList = itemStack.getEnchantments();
        if (nBTTagList == null) {
            return;
        }
        for (int i = 0; i < nBTTagList.size(); ++i) {
            short s = ((NBTTagCompound)nBTTagList.get(i)).getShort("id");
            short s2 = ((NBTTagCompound)nBTTagList.get(i)).getShort("lvl");
            if (Enchantment.byId[s] == null) continue;
            enchantmentModifier.a(Enchantment.byId[s], s2);
        }
    }

    private static void a(EnchantmentModifier enchantmentModifier, ItemStack[] itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            EnchantmentManager.a(enchantmentModifier, itemStack);
        }
    }

    public static int a(PlayerInventory playerInventory, DamageSource damageSource) {
        EnchantmentManager.b.a = 0;
        EnchantmentManager.b.b = damageSource;
        EnchantmentManager.a((EnchantmentModifier)b, playerInventory.armor);
        if (EnchantmentManager.b.a > 25) {
            EnchantmentManager.b.a = 25;
        }
        return (EnchantmentManager.b.a + 1 >> 1) + random.nextInt((EnchantmentManager.b.a >> 1) + 1);
    }

    public static int a(PlayerInventory playerInventory, EntityLiving entityLiving) {
        EnchantmentManager.c.a = 0;
        EnchantmentManager.c.b = entityLiving;
        EnchantmentManager.a((EnchantmentModifier)c, playerInventory.getItemInHand());
        if (EnchantmentManager.c.a > 0) {
            return 1 + random.nextInt(EnchantmentManager.c.a);
        }
        return 0;
    }

    public static int getKnockbackEnchantmentLevel(PlayerInventory playerInventory, EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.KNOCKBACK.id, playerInventory.getItemInHand());
    }

    public static int getFireAspectEnchantmentLevel(PlayerInventory playerInventory, EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.FIRE_ASPECT.id, playerInventory.getItemInHand());
    }

    public static int getOxygenEnchantmentLevel(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.OXYGEN.id, playerInventory.armor);
    }

    public static int getDigSpeedEnchantmentLevel(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.DIG_SPEED.id, playerInventory.getItemInHand());
    }

    public static int getDurabilityEnchantmentLevel(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.DURABILITY.id, playerInventory.getItemInHand());
    }

    public static boolean hasSilkTouchEnchantment(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.SILK_TOUCH.id, playerInventory.getItemInHand()) > 0;
    }

    public static int getBonusBlockLootEnchantmentLevel(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS.id, playerInventory.getItemInHand());
    }

    public static int getBonusMonsterLootEnchantmentLevel(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS.id, playerInventory.getItemInHand());
    }

    public static boolean hasWaterWorkerEnchantment(PlayerInventory playerInventory) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.WATER_WORKER.id, playerInventory.armor) > 0;
    }

    public static int a(Random random, int n, int n2, ItemStack itemStack) {
        Item item = itemStack.getItem();
        int n3 = item.b();
        if (n3 <= 0) {
            return 0;
        }
        if (n2 > 15) {
            n2 = 15;
        }
        int n4 = random.nextInt(8) + 1 + (n2 >> 1) + random.nextInt(n2 + 1);
        if (n == 0) {
            return Math.max(n4 / 3, 1);
        }
        if (n == 1) {
            return n4 * 2 / 3 + 1;
        }
        return Math.max(n4, n2 * 2);
    }

    public static ItemStack a(Random random, ItemStack itemStack, int n) {
        List list = EnchantmentManager.b(random, itemStack, n);
        if (list != null) {
            for (EnchantmentInstance enchantmentInstance : list) {
                itemStack.addEnchantment(enchantmentInstance.enchantment, enchantmentInstance.level);
            }
        }
        return itemStack;
    }

    public static List b(Random random, ItemStack itemStack, int n) {
        EnchantmentInstance enchantmentInstance;
        float f;
        Item item = itemStack.getItem();
        int n2 = item.b();
        if (n2 <= 0) {
            return null;
        }
        n2 /= 2;
        int n3 = (n2 = 1 + random.nextInt((n2 >> 1) + 1) + random.nextInt((n2 >> 1) + 1)) + n;
        int n4 = (int)((float)n3 * (1.0f + (f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f)) + 0.5f);
        if (n4 < 1) {
            n4 = 1;
        }
        ArrayList<Object> arrayList = null;
        Map map = EnchantmentManager.b(n4, itemStack);
        if (map != null && !map.isEmpty() && (enchantmentInstance = (EnchantmentInstance)WeightedRandom.a(random, map.values())) != null) {
            arrayList = new ArrayList<Object>();
            arrayList.add(enchantmentInstance);
            for (int i = n4; random.nextInt(50) <= i; i >>= 1) {
                Object object;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (Integer)iterator.next();
                    boolean bl = true;
                    for (EnchantmentInstance enchantmentInstance2 : arrayList) {
                        if (enchantmentInstance2.enchantment.a(Enchantment.byId[(Integer)object])) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                    iterator.remove();
                }
                if (map.isEmpty()) continue;
                object = (EnchantmentInstance)WeightedRandom.a(random, map.values());
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public static Map b(int n, ItemStack itemStack) {
        Item item = itemStack.getItem();
        HashMap<Integer, EnchantmentInstance> hashMap = null;
        for (Enchantment enchantment : Enchantment.byId) {
            if (enchantment == null || !enchantment.slot.canEnchant(item)) continue;
            for (int i = enchantment.getStartLevel(); i <= enchantment.getMaxLevel(); ++i) {
                if (n < enchantment.a(i) || n > enchantment.b(i)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<Integer, EnchantmentInstance>();
                }
                hashMap.put(enchantment.id, new EnchantmentInstance(enchantment, i));
            }
        }
        return hashMap;
    }
}

