/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.Configuration;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.KickException;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketInputStream;
import net.md_5.bungee.plugin.LoginEvent;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;

public class InitialHandler
implements Runnable {
    private final Socket socket;
    private PacketInputStream in;
    private OutputStream out;

    public InitialHandler(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new PacketInputStream(socket.getInputStream());
        this.out = socket.getOutputStream();
    }

    @Override
    public void run() {
        try {
            byte[] packet = this.in.readPacket();
            int id = Util.getId(packet);
            switch (id) {
                case 2: {
                    byte[] custom;
                    Packet2Handshake handshake = new Packet2Handshake(packet);
                    LoginEvent event = new LoginEvent(handshake.username, this.socket.getInetAddress(), handshake.host);
                    BungeeCord.instance.pluginManager.onHandshake(event);
                    if (event.isCancelled()) {
                        throw new KickException(event.getCancelReason());
                    }
                    PacketFDEncryptionRequest request = EncryptionUtil.encryptRequest();
                    this.out.write(request.getPacket());
                    PacketFCEncryptionResponse response = new PacketFCEncryptionResponse(this.in.readPacket());
                    SecretKey shared = EncryptionUtil.getSecret(response, request);
                    if (!EncryptionUtil.isAuthenticated(handshake.username, request.serverId, shared)) {
                        throw new KickException("Not authenticated with minecraft.net");
                    }
                    BungeeCord.instance.pluginManager.onLogin(event);
                    if (event.isCancelled()) {
                        throw new KickException(event.getCancelReason());
                    }
                    this.out.write(new PacketFCEncryptionResponse().getPacket());
                    this.in = new PacketInputStream(new CipherInputStream(this.socket.getInputStream(), EncryptionUtil.getCipher(false, shared)));
                    this.out = new CipherOutputStream(this.socket.getOutputStream(), EncryptionUtil.getCipher(true, shared));
                    ArrayList<byte[]> customPackets = new ArrayList<byte[]>();
                    while (Util.getId(custom = this.in.readPacket()) != 205) {
                        customPackets.add(custom);
                    }
                    UserConnection userCon = new UserConnection(this.socket, this.in, this.out, handshake, customPackets);
                    userCon.connect(BungeeCord.instance.config.getServer(handshake.username, handshake.host));
                    break;
                }
                case 254: {
                    this.socket.setSoTimeout(100);
                    boolean newPing = false;
                    try {
                        this.socket.getInputStream().read();
                        newPing = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Configuration conf = BungeeCord.instance.config;
                    String ping = newPing ? "\u00a71\u000049\u00001.4.4\u0000" + conf.motd + "\u0000" + BungeeCord.instance.connections.size() + "\u0000" + conf.maxPlayers : conf.motd + '\u00a7' + BungeeCord.instance.connections.size() + '\u00a7' + conf.maxPlayers;
                    throw new KickException(ping);
                }
                default: {
                    if (id == 250) {
                        this.run();
                    }
                    break;
                }
            }
        }
        catch (KickException ex) {
            this.kick(ex.getMessage());
        }
        catch (Exception ex) {
            this.kick("[Proxy Error] " + Util.exception(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kick(String message) {
        try {
            this.out.write(new PacketFFKick(message).getPacket());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.out.flush();
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

