/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.util.Map;
import java.util.TimeZone;
import org.yaml.snakeyaml.emitter.ScalarAnalysis;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumperOptions {
    private ScalarStyle defaultStyle = ScalarStyle.PLAIN;
    private FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    private boolean canonical = false;
    private boolean allowUnicode = true;
    private boolean allowReadOnlyProperties = false;
    private int indent = 2;
    private int bestWidth = 80;
    private LineBreak lineBreak = LineBreak.UNIX;
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private TimeZone timeZone = null;
    private Tag explicitRoot = null;
    private Version version = null;
    private Map<String, String> tags = null;
    private Boolean prettyFlow = false;

    public boolean isAllowUnicode() {
        return this.allowUnicode;
    }

    public ScalarStyle getDefaultScalarStyle() {
        return this.defaultStyle;
    }

    public int getIndent() {
        return this.indent;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public int getWidth() {
        return this.bestWidth;
    }

    public LineBreak getLineBreak() {
        return this.lineBreak;
    }

    public void setDefaultFlowStyle(FlowStyle defaultFlowStyle) {
        if (defaultFlowStyle == null) {
            throw new NullPointerException("Use FlowStyle enum.");
        }
        this.defaultFlowStyle = defaultFlowStyle;
    }

    public FlowStyle getDefaultFlowStyle() {
        return this.defaultFlowStyle;
    }

    public Tag getExplicitRoot() {
        return this.explicitRoot;
    }

    public boolean isExplicitStart() {
        return this.explicitStart;
    }

    public boolean isExplicitEnd() {
        return this.explicitEnd;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ScalarStyle calculateScalarStyle(ScalarAnalysis analysis, ScalarStyle style) {
        return style;
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Version
    extends Enum<Version> {
        public static final /* enum */ Version V1_0 = new Version(new Integer[]{1, 0});
        public static final /* enum */ Version V1_1 = new Version(new Integer[]{1, 1});
        private Integer[] version;
        private static final /* synthetic */ Version[] $VALUES;

        private Version(Integer[] version) {
            this.version = version;
        }

        public Integer[] getArray() {
            return this.version;
        }

        public String getRepresentation() {
            return this.version[0] + "." + this.version[1];
        }

        public String toString() {
            return "Version: " + this.getRepresentation();
        }

        static {
            $VALUES = new Version[]{V1_0, V1_1};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LineBreak
    extends Enum<LineBreak> {
        public static final /* enum */ LineBreak WIN = new LineBreak("\r\n");
        public static final /* enum */ LineBreak MAC = new LineBreak("\r");
        public static final /* enum */ LineBreak UNIX = new LineBreak("\n");
        private String lineBreak;
        private static final /* synthetic */ LineBreak[] $VALUES;

        private LineBreak(String lineBreak) {
            this.lineBreak = lineBreak;
        }

        public String getString() {
            return this.lineBreak;
        }

        public String toString() {
            return "Line break: " + this.name();
        }

        static {
            $VALUES = new LineBreak[]{WIN, MAC, UNIX};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FlowStyle
    extends Enum<FlowStyle> {
        public static final /* enum */ FlowStyle FLOW = new FlowStyle(Boolean.TRUE);
        public static final /* enum */ FlowStyle BLOCK = new FlowStyle(Boolean.FALSE);
        public static final /* enum */ FlowStyle AUTO = new FlowStyle(null);
        private Boolean styleBoolean;
        private static final /* synthetic */ FlowStyle[] $VALUES;

        private FlowStyle(Boolean flowStyle) {
            this.styleBoolean = flowStyle;
        }

        public Boolean getStyleBoolean() {
            return this.styleBoolean;
        }

        public String toString() {
            return "Flow style: '" + this.styleBoolean + "'";
        }

        static {
            $VALUES = new FlowStyle[]{FLOW, BLOCK, AUTO};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScalarStyle
    extends Enum<ScalarStyle> {
        public static final /* enum */ ScalarStyle DOUBLE_QUOTED = new ScalarStyle(Character.valueOf('\"'));
        public static final /* enum */ ScalarStyle SINGLE_QUOTED = new ScalarStyle(Character.valueOf('\''));
        public static final /* enum */ ScalarStyle LITERAL = new ScalarStyle(Character.valueOf('|'));
        public static final /* enum */ ScalarStyle FOLDED = new ScalarStyle(Character.valueOf('>'));
        public static final /* enum */ ScalarStyle PLAIN = new ScalarStyle(null);
        private Character styleChar;
        private static final /* synthetic */ ScalarStyle[] $VALUES;

        private ScalarStyle(Character style) {
            this.styleChar = style;
        }

        public Character getChar() {
            return this.styleChar;
        }

        public String toString() {
            return "Scalar style: '" + this.styleChar + "'";
        }

        public static ScalarStyle createStyle(Character style) {
            if (style == null) {
                return PLAIN;
            }
            switch (style.charValue()) {
                case '\"': {
                    return DOUBLE_QUOTED;
                }
                case '\'': {
                    return SINGLE_QUOTED;
                }
                case '|': {
                    return LITERAL;
                }
                case '>': {
                    return FOLDED;
                }
            }
            throw new YAMLException("Unknown scalar style character: " + style);
        }

        static {
            $VALUES = new ScalarStyle[]{DOUBLE_QUOTED, SINGLE_QUOTED, LITERAL, FOLDED, PLAIN};
        }
    }
}

