/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.beans.ConstructorProperties;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import lombok.NonNull;

public class CipherBase {
    @NonNull
    private final Cipher cipher;
    private ThreadLocal<byte[]> heapInLocal = new EmptyByteThreadLocal();
    private ThreadLocal<byte[]> heapOutLocal = new EmptyByteThreadLocal();

    private byte[] bufToByte(ByteBuf in) {
        int readableBytes;
        byte[] heapIn = this.heapInLocal.get();
        if (heapIn.length < (readableBytes = in.readableBytes())) {
            heapIn = new byte[readableBytes];
            this.heapInLocal.set(heapIn);
        }
        in.readBytes(heapIn, 0, readableBytes);
        return heapIn;
    }

    protected ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws ShortBufferException {
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        ByteBuf heapOut = ctx.alloc().heapBuffer(this.cipher.getOutputSize(readableBytes));
        heapOut.writerIndex(this.cipher.update(heapIn, 0, readableBytes, heapOut.array(), heapOut.arrayOffset()));
        return heapOut;
    }

    protected void cipher(ByteBuf in, ByteBuf out) throws ShortBufferException {
        int outputSize;
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        byte[] heapOut = this.heapOutLocal.get();
        if (heapOut.length < (outputSize = this.cipher.getOutputSize(readableBytes))) {
            heapOut = new byte[outputSize];
            this.heapOutLocal.set(heapOut);
        }
        out.writeBytes(heapOut, 0, this.cipher.update(heapIn, 0, readableBytes, heapOut));
    }

    @ConstructorProperties(value={"cipher"})
    protected CipherBase(@NonNull Cipher cipher) {
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        this.cipher = cipher;
    }

    private static class EmptyByteThreadLocal
    extends ThreadLocal<byte[]> {
        private EmptyByteThreadLocal() {
        }

        @Override
        protected byte[] initialValue() {
            return new byte[0];
        }
    }
}

