/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.PlatformDependent;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.PacketConstants;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.api.tab.TabListHandler;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.util.CaseInsensitiveSet;
import net.md_5.bungee.util.TextWrapper;

public final class UserConnection
implements ProxiedPlayer {
    @NonNull
    private final ProxyServer bungee;
    @NonNull
    private final ChannelWrapper ch;
    @NonNull
    private final String name;
    private final InitialHandler pendingConnection;
    private ServerConnection server;
    private final Object switchMutex = new Object();
    private final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();
    private TabListHandler tabList;
    private int sentPingId;
    private long sentPingTime;
    private int ping = 100;
    private ServerInfo reconnectServer;
    private final Collection<String> groups = new CaseInsensitiveSet();
    private final Collection<String> permissions = new CaseInsensitiveSet();
    private int clientEntityId;
    private int serverEntityId;
    private ClientSettings settings;
    private final Scoreboard serverSentScoreboard = new Scoreboard();
    private String displayName;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            UserConnection.this.ch.write(packet);
        }
    };

    public void init() {
        this.displayName = this.name;
        try {
            this.tabList = this.getPendingConnection().getListener().getTabList().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        this.tabList.init(this);
        Collection<String> g = this.bungee.getConfigurationAdapter().getGroups(this.name);
        for (String s : g) {
            this.addGroups(s);
        }
    }

    @Override
    public void setTabList(TabListHandler tabList) {
        tabList.init(this);
        this.tabList = tabList;
    }

    public void sendPacket(PacketWrapper packet) {
        this.ch.write(packet);
    }

    @Deprecated
    public boolean isActive() {
        return !this.ch.isClosed();
    }

    @Override
    public void setDisplayName(String name) {
        Preconditions.checkNotNull(name, "displayName");
        Preconditions.checkArgument(name.length() <= 16, "Display name cannot be longer than 16 characters");
        this.getTabList().onDisconnect();
        this.displayName = name;
        this.getTabList().onConnect();
    }

    @Override
    public void connect(ServerInfo target) {
        this.connect(target, false);
    }

    void sendDimensionSwitch() {
        this.unsafe().sendPacket(PacketConstants.DIM1_SWITCH);
        this.unsafe().sendPacket(PacketConstants.DIM2_SWITCH);
    }

    public void connectNow(ServerInfo target) {
        this.sendDimensionSwitch();
        this.connect(target);
    }

    public void connect(ServerInfo info, final boolean retry) {
        Preconditions.checkNotNull(info, "info");
        ServerConnectEvent event = new ServerConnectEvent(this, info);
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            return;
        }
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equals(this.getServer().getInfo(), target)) {
            this.sendMessage(this.bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (this.pendingConnects.contains(target)) {
            this.sendMessage(this.bungee.getTranslation("already_connecting", new Object[0]));
            return;
        }
        this.pendingConnects.add(target);
        ChannelInitializer initializer = new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().addAfter(PipelineUtils.FRAME_DECODER, PipelineUtils.PACKET_DECODER, new MinecraftDecoder(Protocol.HANDSHAKE, false));
                ch.pipeline().addAfter(PipelineUtils.FRAME_PREPENDER, PipelineUtils.PACKET_ENCODER, new MinecraftEncoder(Protocol.HANDSHAKE, false));
                ch.pipeline().get(HandlerBoss.class).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = ProxyServer.getInstance().getServers().get(UserConnection.this.getPendingConnection().getListener().getFallbackServer());
                    if (retry && target != def && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_lobby", new Object[0]));
                        UserConnection.this.connect(def, false);
                    } else if (UserConnection.this.server == null) {
                        UserConnection.this.disconnect(UserConnection.this.bungee.getTranslation("fallback_kick", new Object[0]) + future.cause().getClass().getName());
                    } else {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_kick", new Object[0]) + future.cause().getClass().getName());
                    }
                }
            }
        };
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(BungeeCord.getInstance().eventLoops)).handler(initializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).remoteAddress(target.getAddress());
        if (this.getPendingConnection().getListener().isSetLocalAddress() && !PlatformDependent.isWindows()) {
            b.localAddress(this.getPendingConnection().getListener().getHost().getHostString(), 0);
        }
        b.connect().addListener(listener);
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (this.ch.getHandle().isActive()) {
            this.bungee.getLogger().log(Level.INFO, "[" + this.getName() + "] disconnected with: " + reason);
            this.unsafe().sendPacket(new Kick(Util.stupify(reason)));
            this.ch.close();
            if (this.server != null) {
                this.server.disconnect("Quitting");
            }
        }
    }

    @Override
    public void chat(String message) {
        Preconditions.checkState(this.server != null, "Not connected to server");
        this.server.getCh().write(new Chat(message));
    }

    @Override
    public void sendMessage(String message) {
        for (String s : TextWrapper.wrapText(message)) {
            this.unsafe().sendPacket(new Chat(Util.stupify(s)));
        }
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.unsafe().sendPacket(new PluginMessage(channel, data));
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    @Override
    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.bungee.getPluginManager().callEvent(new PermissionCheckEvent(this, permission, this.permissions.contains(permission))).hasPermission();
    }

    @Override
    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public String getUUID() {
        return this.getPendingConnection().getUUID();
    }

    @ConstructorProperties(value={"bungee", "ch", "name", "pendingConnection"})
    public UserConnection(@NonNull ProxyServer bungee, @NonNull ChannelWrapper ch, @NonNull String name, InitialHandler pendingConnection) {
        if (bungee == null) {
            throw new NullPointerException("bungee");
        }
        if (ch == null) {
            throw new NullPointerException("ch");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public Object getSwitchMutex() {
        return this.switchMutex;
    }

    public Collection<ServerInfo> getPendingConnects() {
        return this.pendingConnects;
    }

    @Override
    public TabListHandler getTabList() {
        return this.tabList;
    }

    public int getSentPingId() {
        return this.sentPingId;
    }

    public void setSentPingId(int sentPingId) {
        this.sentPingId = sentPingId;
    }

    public long getSentPingTime() {
        return this.sentPingTime;
    }

    public void setSentPingTime(long sentPingTime) {
        this.sentPingTime = sentPingTime;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    @Override
    public ServerInfo getReconnectServer() {
        return this.reconnectServer;
    }

    @Override
    public void setReconnectServer(ServerInfo reconnectServer) {
        this.reconnectServer = reconnectServer;
    }

    public int getClientEntityId() {
        return this.clientEntityId;
    }

    public void setClientEntityId(int clientEntityId) {
        this.clientEntityId = clientEntityId;
    }

    public int getServerEntityId() {
        return this.serverEntityId;
    }

    public void setServerEntityId(int serverEntityId) {
        this.serverEntityId = serverEntityId;
    }

    public ClientSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ClientSettings settings) {
        this.settings = settings;
    }

    public Scoreboard getServerSentScoreboard() {
        return this.serverSentScoreboard;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }
}

