/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Queue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftOutput;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.Team;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.LOGIN_SUCCESS;

    @Override
    public void exception(Throwable t) throws Exception {
        String message = "Exception Connecting:" + Util.exception(t);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage((Object)((Object)ChatColor.RED) + message);
        }
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Login");
        out.writeUTF(this.user.getAddress().getHostString());
        out.writeInt(this.user.getAddress().getPort());
        channel.write(this.user.getPendingConnection().getHandshake());
        channel.setProtocol(Protocol.LOGIN);
        channel.write(this.user.getPendingConnection().getLoginRequest());
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
    }

    @Override
    public void handle(LoginSuccess loginSuccess) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN_SUCCESS, "Not exepcting LOGIN_SUCCESS");
        this.ch.setProtocol(Protocol.GAME);
        this.thisState = State.LOGIN;
        throw new CancelSendSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not exepcting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target);
        ServerConnectedEvent event = new ServerConnectedEvent(this.user, server);
        this.bungee.getPluginManager().callEvent(event);
        this.ch.write(BungeeCord.getInstance().registerChannels());
        Queue<DefinedPacket> packetQueue = this.target.getPacketQueue();
        Object object = packetQueue;
        synchronized (object) {
            while (!packetQueue.isEmpty()) {
                this.ch.write(packetQueue.poll());
            }
        }
        for (PluginMessage message : this.user.getPendingConnection().getRegisterMessages()) {
            this.ch.write(message);
        }
        if (this.user.getSettings() != null) {
            this.ch.write(this.user.getSettings());
        }
        object = this.user.getSwitchMutex();
        synchronized (object) {
            if (this.user.getServer() == null) {
                this.user.setClientEntityId(login.getEntityId());
                this.user.setServerEntityId(login.getEntityId());
                Login modLogin = new Login(login.getEntityId(), login.getGameMode(), (byte)login.getDimension(), login.getDifficulty(), (byte)this.user.getPendingConnection().getListener().getTabListSize(), login.getLevelType());
                this.user.unsafe().sendPacket(modLogin);
                MinecraftOutput out = new MinecraftOutput();
                out.writeStringUTF8WithoutLengthHeaderBecauseDinnerboneStuffedUpTheMCBrandPacket(ProxyServer.getInstance().getName() + " (" + ProxyServer.getInstance().getVersion() + ")");
                this.user.unsafe().sendPacket(new PluginMessage("MC|Brand", out.toArray()));
            } else {
                this.user.getTabList().onServerChange();
                Scoreboard serverScoreboard = this.user.getServerSentScoreboard();
                for (Objective objective : serverScoreboard.getObjectives()) {
                    this.user.unsafe().sendPacket(new ScoreboardObjective(objective.getName(), objective.getValue(), 1));
                }
                for (net.md_5.bungee.api.score.Team team : serverScoreboard.getTeams()) {
                    this.user.unsafe().sendPacket(new Team(team.getName()));
                }
                serverScoreboard.clear();
                this.user.sendDimensionSwitch();
                this.user.setServerEntityId(login.getEntityId());
                this.user.unsafe().sendPacket(new Respawn(login.getDimension(), login.getDifficulty(), login.getGameMode(), login.getLevelType()));
                this.user.getServer().setObsolete(true);
                this.user.getServer().disconnect("Quitting");
            }
            if (!this.user.isActive()) {
                server.disconnect("Quitting");
                this.bungee.getLogger().warning("No client connected for pending server!");
                return;
            }
            this.target.addPlayer(this.user);
            this.user.getPendingConnects().remove(this.target);
            this.user.setServer(server);
            this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(this.bungee, this.user, server));
        }
        this.bungee.getPluginManager().callEvent(new ServerSwitchEvent(this.user));
        this.thisState = State.FINISHED;
        throw new CancelSendSignal();
    }

    @Override
    public void handle(EncryptionRequest encryptionRequest) throws Exception {
        throw new RuntimeException("Server is online mode!");
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.user.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.target, def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.user, kick.getMessage(), def, ServerKickEvent.State.CONNECTING))).isCancelled() && event.getCancelServer() != null) {
            this.user.connect(event.getCancelServer());
            return;
        }
        String message = this.bungee.getTranslation("connect_kick", new Object[0]) + this.target.getName() + ": " + event.getKickReason();
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "user", "target"})
    public ServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    private static enum State {
        LOGIN_SUCCESS,
        ENCRYPT_RESPONSE,
        LOGIN,
        FINISHED;

    }
}

