/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.DefinedPacket;

public class EntityMap {
    public static final int[][] entityIds = new int[256][];

    public static void rewrite(ByteBuf packet, int oldId, int newId) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        int[] idArray = entityIds[packetId];
        if (idArray != null) {
            for (int pos : idArray) {
                int readId = packet.getInt(packetIdLength + pos);
                if (readId != oldId) continue;
                packet.setInt(packetIdLength + pos, newId);
            }
        }
        packet.readerIndex(readerIndex);
    }

    static {
        EntityMap.entityIds[10] = new int[]{0};
        EntityMap.entityIds[13] = new int[]{4};
        EntityMap.entityIds[18] = new int[]{0};
        EntityMap.entityIds[27] = new int[]{0, 4};
        EntityMap.entityIds[28] = new int[]{0};
        EntityMap.entityIds[29] = new int[]{0};
        EntityMap.entityIds[30] = new int[]{0};
        EntityMap.entityIds[32] = new int[]{0};
    }
}

