/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ControllerJump;
import net.minecraft.server.ControllerLook;
import net.minecraft.server.ControllerMove;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAIBodyControl;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntitySenses;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Navigation;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.PotionBrewer;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityLiving
extends Entity {
    public int maxNoDamageTicks = 20;
    public float ao;
    public float ap;
    public float aq = 0.0f;
    public float ar = 0.0f;
    public float as = 0.0f;
    public float at = 0.0f;
    protected float au;
    protected float av;
    protected float aw;
    protected float ax;
    protected boolean ay = true;
    protected String texture = "/mob/char.png";
    protected boolean aA = true;
    protected float aB = 0.0f;
    protected String aC = null;
    protected float aD = 1.0f;
    protected int aE = 0;
    protected float aF = 0.0f;
    public float aG = 0.1f;
    public float aH = 0.02f;
    public float aI;
    public float aJ;
    protected int health;
    public int aL;
    protected int aM;
    private int a;
    public int hurtTicks;
    public int aO;
    public float aP = 0.0f;
    public int deathTicks = 0;
    public int attackTicks = 0;
    public float aS;
    public float aT;
    protected boolean aU = false;
    protected int aV;
    public int aW = -1;
    public float aX = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float aY;
    public float aZ;
    public float ba;
    protected EntityHuman killer = null;
    protected int lastDamageByPlayerTime = 0;
    private EntityLiving lastDamager = null;
    private int c = 0;
    private EntityLiving d = null;
    public int bd = 0;
    public int be = 0;
    protected HashMap effects = new HashMap();
    private boolean updateEffects = true;
    private int f;
    private ControllerLook lookController;
    private ControllerMove moveController;
    private ControllerJump jumpController;
    private EntityAIBodyControl senses;
    private Navigation navigation;
    protected final PathfinderGoalSelector goalSelector;
    protected final PathfinderGoalSelector targetSelector;
    private EntityLiving bz;
    private EntitySenses bA;
    private float bB;
    private ChunkCoordinates bC = new ChunkCoordinates(0, 0, 0);
    private float bD = -1.0f;
    protected int bi;
    protected double bj;
    protected double bk;
    protected double bl;
    protected double bm;
    protected double bn;
    float bo = 0.0f;
    protected int lastDamage = 0;
    protected int bq = 0;
    protected float br;
    protected float bs;
    protected float bt;
    protected boolean bu = false;
    protected float bv = 0.0f;
    protected float bw = 0.7f;
    private int bE = 0;
    private Entity bF;
    protected int bx = 0;

    public EntityLiving(World world) {
        super(world);
        this.health = this.getMaxHealth();
        this.m = true;
        this.goalSelector = new PathfinderGoalSelector(world == null || world.methodProfiler == null ? null : world.methodProfiler);
        this.targetSelector = new PathfinderGoalSelector(world == null || world.methodProfiler == null ? null : world.methodProfiler);
        this.lookController = new ControllerLook(this);
        this.moveController = new ControllerMove(this);
        this.jumpController = new ControllerJump(this);
        this.senses = new EntityAIBodyControl(this);
        this.navigation = new Navigation(this, world, 16.0f);
        this.bA = new EntitySenses(this);
        this.ap = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.ao = (float)Math.random() * 12398.0f;
        this.as = this.yaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.W = 0.5f;
    }

    public ControllerLook getControllerLook() {
        return this.lookController;
    }

    public ControllerMove getControllerMove() {
        return this.moveController;
    }

    public ControllerJump getControllerJump() {
        return this.jumpController;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public EntitySenses at() {
        return this.bA;
    }

    public Random au() {
        return this.random;
    }

    public EntityLiving av() {
        return this.lastDamager;
    }

    public EntityLiving aw() {
        return this.d;
    }

    public void j(Entity entity) {
        if (entity instanceof EntityLiving) {
            this.d = (EntityLiving)entity;
        }
    }

    public int ax() {
        return this.bq;
    }

    public float am() {
        return this.as;
    }

    public float ay() {
        return this.bB;
    }

    public void e(float f) {
        this.bB = f;
        this.f(f);
    }

    public boolean k(Entity entity) {
        this.j(entity);
        return false;
    }

    public EntityLiving az() {
        return this.bz;
    }

    public void b(EntityLiving entityLiving) {
        this.bz = entityLiving;
    }

    public boolean a(Class clazz) {
        return EntityCreeper.class != clazz && EntityGhast.class != clazz;
    }

    public void aA() {
    }

    public boolean aB() {
        return this.d(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
    }

    public boolean d(int n, int n2, int n3) {
        if (this.bD == -1.0f) {
            return true;
        }
        return this.bC.e(n, n2, n3) < this.bD * this.bD;
    }

    public void b(int n, int n2, int n3, int n4) {
        this.bC.b(n, n2, n3);
        this.bD = n4;
    }

    public ChunkCoordinates aC() {
        return this.bC;
    }

    public float aD() {
        return this.bD;
    }

    public void aE() {
        this.bD = -1.0f;
    }

    public boolean aF() {
        return this.bD != -1.0f;
    }

    public void c(EntityLiving entityLiving) {
        this.lastDamager = entityLiving;
        this.c = this.lastDamager != null ? 60 : 0;
    }

    protected void a() {
        this.datawatcher.a(8, this.f);
    }

    public boolean l(Entity entity) {
        return this.world.a(Vec3D.a().create(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ), Vec3D.a().create(entity.locX, entity.locY + (double)entity.getHeadHeight(), entity.locZ)) == null;
    }

    public boolean L() {
        return !this.dead;
    }

    public boolean M() {
        return !this.dead;
    }

    public float getHeadHeight() {
        return this.length * 0.85f;
    }

    public int aG() {
        return 80;
    }

    public void aH() {
        String string = this.aQ();
        if (string != null) {
            this.world.makeSound(this, string, this.aP(), this.i());
        }
    }

    public void z() {
        this.aI = this.aJ;
        super.z();
        this.world.methodProfiler.a("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.a++) {
            this.a = -this.aG();
            this.aH();
        }
        if (this.isAlive() && this.inBlock()) {
            this.damageEntity(DamageSource.STUCK, 1);
        }
        if (this.isFireproof() || this.world.isStatic) {
            this.extinguish();
        }
        if (this.isAlive() && this.a(Material.WATER) && !this.aU() && !this.effects.containsKey(MobEffectList.WATER_BREATHING.id)) {
            this.setAirTicks(this.h(this.getAirTicks()));
            if (this.getAirTicks() == -20) {
                this.setAirTicks(0);
                for (int i = 0; i < 8; ++i) {
                    float f = this.random.nextFloat() - this.random.nextFloat();
                    float f2 = this.random.nextFloat() - this.random.nextFloat();
                    float f3 = this.random.nextFloat() - this.random.nextFloat();
                    this.world.a("bubble", this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                }
                this.damageEntity(DamageSource.DROWN, 2);
            }
            this.extinguish();
        } else {
            this.setAirTicks(300);
        }
        this.aS = this.aT;
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.hurtTicks > 0) {
            --this.hurtTicks;
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        if (this.health <= 0) {
            this.aI();
        }
        if (this.lastDamageByPlayerTime > 0) {
            --this.lastDamageByPlayerTime;
        } else {
            this.killer = null;
        }
        if (this.d != null && !this.d.isAlive()) {
            this.d = null;
        }
        if (this.lastDamager != null) {
            if (!this.lastDamager.isAlive()) {
                this.c((EntityLiving)null);
            } else if (this.c > 0) {
                --this.c;
            } else {
                this.c((EntityLiving)null);
            }
        }
        this.bo();
        this.ax = this.aw;
        this.ar = this.aq;
        this.at = this.as;
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.world.methodProfiler.b();
    }

    protected void aI() {
        ++this.deathTicks;
        if (this.deathTicks == 20) {
            int n;
            if (!(this.world.isStatic || this.lastDamageByPlayerTime <= 0 && !this.alwaysGivesExp() || this.isBaby())) {
                int n2;
                for (n = this.getExpValue(this.killer); n > 0; n -= n2) {
                    n2 = EntityExperienceOrb.getOrbValue(n);
                    this.world.addEntity(new EntityExperienceOrb(this.world, this.locX, this.locY, this.locZ, n2));
                }
            }
            this.die();
            for (n = 0; n < 20; ++n) {
                double d = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = this.random.nextGaussian() * 0.02;
                this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, d, d2, d3);
            }
        }
    }

    protected int h(int n) {
        return n - 1;
    }

    protected int getExpValue(EntityHuman entityHuman) {
        return this.aV;
    }

    protected boolean alwaysGivesExp() {
        return false;
    }

    public void aK() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            double d4 = 10.0;
            this.world.a("explode", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width - d * d4, this.locY + (double)(this.random.nextFloat() * this.length) - d2 * d4, this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width - d3 * d4, d, d2, d3);
        }
    }

    public void U() {
        super.U();
        this.au = this.av;
        this.av = 0.0f;
        this.fallDistance = 0.0f;
    }

    public void h_() {
        super.h_();
        if (this.bd > 0) {
            if (this.be <= 0) {
                this.be = 60;
            }
            --this.be;
            if (this.be <= 0) {
                --this.bd;
            }
        }
        this.d();
        double d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f = (float)(d * d + d2 * d2);
        float f2 = this.aq;
        float f3 = 0.0f;
        this.au = this.av;
        float f4 = 0.0f;
        if (!(f <= 0.0025000002f)) {
            f4 = 1.0f;
            f3 = (float)Math.sqrt(f) * 3.0f;
            f2 = (float)Math.atan2(d2, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.aJ > 0.0f) {
            f2 = this.yaw;
        }
        if (!this.onGround) {
            f4 = 0.0f;
        }
        this.av += (f4 - this.av) * 0.3f;
        this.world.methodProfiler.a("headTurn");
        if (this.aV()) {
            this.senses.a();
        } else {
            boolean bl;
            float f5 = MathHelper.g(f2 - this.aq);
            this.aq += f5 * 0.3f;
            float f6 = MathHelper.g(this.yaw - this.aq);
            boolean bl2 = bl = f6 < -90.0f || f6 >= 90.0f;
            if (f6 < -75.0f) {
                f6 = -75.0f;
            }
            if (f6 >= 75.0f) {
                f6 = 75.0f;
            }
            this.aq = this.yaw - f6;
            if (f6 * f6 > 2500.0f) {
                this.aq += f6 * 0.2f;
            }
            if (bl) {
                f3 *= -1.0f;
            }
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("rangeChecks");
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        while (this.aq - this.ar < -180.0f) {
            this.ar -= 360.0f;
        }
        while (this.aq - this.ar >= 180.0f) {
            this.ar += 360.0f;
        }
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.as - this.at < -180.0f) {
            this.at -= 360.0f;
        }
        while (this.as - this.at >= 180.0f) {
            this.at += 360.0f;
        }
        this.world.methodProfiler.b();
        this.aw += f3;
    }

    public void heal(int n) {
        if (this.health <= 0) {
            return;
        }
        this.health += n;
        if (this.health > this.getMaxHealth()) {
            this.health = this.getMaxHealth();
        }
        this.noDamageTicks = this.maxNoDamageTicks / 2;
    }

    public abstract int getMaxHealth();

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int n) {
        this.health = n;
        if (n > this.getMaxHealth()) {
            n = this.getMaxHealth();
        }
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic) {
            return false;
        }
        this.bq = 0;
        if (this.health <= 0) {
            return false;
        }
        if (damageSource.k() && this.hasEffect(MobEffectList.FIRE_RESISTANCE)) {
            return false;
        }
        this.aZ = 1.5f;
        boolean bl = true;
        if ((float)this.noDamageTicks > (float)this.maxNoDamageTicks / 2.0f) {
            if (n <= this.lastDamage) {
                return false;
            }
            this.d(damageSource, n - this.lastDamage);
            this.lastDamage = n;
            bl = false;
        } else {
            this.lastDamage = n;
            this.aL = this.health;
            this.noDamageTicks = this.maxNoDamageTicks;
            this.d(damageSource, n);
            this.aO = 10;
            this.hurtTicks = 10;
        }
        this.aP = 0.0f;
        Entity entity = damageSource.getEntity();
        if (entity != null) {
            EntityWolf entityWolf;
            if (entity instanceof EntityLiving) {
                this.c((EntityLiving)entity);
            }
            if (entity instanceof EntityHuman) {
                this.lastDamageByPlayerTime = 60;
                this.killer = (EntityHuman)entity;
            } else if (entity instanceof EntityWolf && (entityWolf = (EntityWolf)entity).isTamed()) {
                this.lastDamageByPlayerTime = 60;
                this.killer = null;
            }
        }
        if (bl) {
            this.world.broadcastEntityEffect(this, (byte)2);
            if (damageSource != DamageSource.DROWN && damageSource != DamageSource.EXPLOSION2) {
                this.K();
            }
            if (entity != null) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                while (d * d + d2 * d2 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.aP = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - this.yaw;
                this.a(entity, n, d, d2);
            } else {
                this.aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (bl) {
                this.world.makeSound(this, this.aS(), this.aP(), this.i());
            }
            this.die(damageSource);
        } else if (bl) {
            this.world.makeSound(this, this.aR(), this.aP(), this.i());
        }
        return true;
    }

    private float i() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    public int aO() {
        return 0;
    }

    protected void k(int n) {
    }

    protected int b(DamageSource damageSource, int n) {
        if (!damageSource.ignoresArmor()) {
            int n2 = 25 - this.aO();
            int n3 = n * n2 + this.aM;
            this.k(n);
            n = n3 / 25;
            this.aM = n3 % 25;
        }
        return n;
    }

    protected int c(DamageSource damageSource, int n) {
        if (this.hasEffect(MobEffectList.RESISTANCE)) {
            int n2 = (this.getEffect(MobEffectList.RESISTANCE).getAmplifier() + 1) * 5;
            int n3 = 25 - n2;
            int n4 = n * n3 + this.aM;
            n = n4 / 25;
            this.aM = n4 % 25;
        }
        return n;
    }

    protected void d(DamageSource damageSource, int n) {
        n = this.b(damageSource, n);
        n = this.c(damageSource, n);
        this.health -= n;
    }

    protected float aP() {
        return 1.0f;
    }

    protected String aQ() {
        return null;
    }

    protected String aR() {
        return "damage.hurtflesh";
    }

    protected String aS() {
        return "damage.hurtflesh";
    }

    public void a(Entity entity, int n, double d, double d2) {
        this.al = true;
        float f = MathHelper.sqrt(d * d + d2 * d2);
        float f2 = 0.4f;
        this.motX /= 2.0;
        this.motY /= 2.0;
        this.motZ /= 2.0;
        this.motX -= d / (double)f * (double)f2;
        this.motY += (double)f2;
        this.motZ -= d2 / (double)f * (double)f2;
        if (this.motY > (double)0.4f) {
            this.motY = 0.4f;
        }
    }

    public void die(DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (this.aE >= 0 && entity != null) {
            entity.c(this, this.aE);
        }
        if (entity != null) {
            entity.a(this);
        }
        this.aU = true;
        if (!this.world.isStatic) {
            int n = 0;
            if (entity instanceof EntityHuman) {
                n = EnchantmentManager.getBonusMonsterLootEnchantmentLevel(((EntityHuman)entity).inventory);
            }
            if (!this.isBaby()) {
                int n2;
                this.dropDeathLoot(this.lastDamageByPlayerTime > 0, n);
                if (this.lastDamageByPlayerTime > 0 && (n2 = this.random.nextInt(200) - n) < 5) {
                    this.l(n2 <= 0 ? 1 : 0);
                }
            }
        }
        this.world.broadcastEntityEffect(this, (byte)3);
    }

    protected void l(int n) {
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.getLootId();
        if (n2 > 0) {
            int n3 = this.random.nextInt(3);
            if (n > 0) {
                n3 += this.random.nextInt(n + 1);
            }
            for (int i = 0; i < n3; ++i) {
                this.b(n2, 1);
            }
        }
    }

    protected int getLootId() {
        return 0;
    }

    protected void a(float f) {
        super.a(f);
        int n = MathHelper.f(f - 3.0f);
        if (n > 0) {
            if (n > 4) {
                this.world.makeSound(this, "damage.fallbig", 1.0f, 1.0f);
            } else {
                this.world.makeSound(this, "damage.fallsmall", 1.0f, 1.0f);
            }
            this.damageEntity(DamageSource.FALL, n);
            int n2 = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY - (double)0.2f - (double)this.height), MathHelper.floor(this.locZ));
            if (n2 > 0) {
                StepSound stepSound = Block.byId[n2].stepSound;
                this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.5f, stepSound.getVolume2() * 0.75f);
            }
        }
    }

    public void e(float f, float f2) {
        double d;
        if (!(!this.H() || this instanceof EntityHuman && ((EntityHuman)this).abilities.isFlying)) {
            d = this.locY;
            this.a(f, f2, this.aV() ? 0.04f : 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= (double)0.8f;
            this.motY *= (double)0.8f;
            this.motZ *= (double)0.8f;
            this.motY -= 0.02;
            if (this.positionChanged && this.c(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else if (!(!this.J() || this instanceof EntityHuman && ((EntityHuman)this).abilities.isFlying)) {
            d = this.locY;
            this.a(f, f2, 0.02f);
            this.move(this.motX, this.motY, this.motZ);
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
            this.motY -= 0.02;
            if (this.positionChanged && this.c(this.motX, this.motY + (double)0.6f - this.locY + d, this.motZ)) {
                this.motY = 0.3f;
            }
        } else {
            float f3;
            float f4 = 0.91f;
            if (this.onGround) {
                f4 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f4 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            float f5 = 0.16277136f / (f4 * f4 * f4);
            if (this.onGround) {
                f3 = this.aV() ? this.ay() : this.aG;
                f3 *= f5;
            } else {
                f3 = this.aH;
            }
            this.a(f, f2, f3);
            f4 = 0.91f;
            if (this.onGround) {
                f4 = 0.54600006f;
                int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
                if (n > 0) {
                    f4 = Block.byId[n].frictionFactor * 0.91f;
                }
            }
            if (this.f_()) {
                boolean bl;
                float f6 = 0.15f;
                if (this.motX < (double)(-f6)) {
                    this.motX = -f6;
                }
                if (this.motX > (double)f6) {
                    this.motX = f6;
                }
                if (this.motZ < (double)(-f6)) {
                    this.motZ = -f6;
                }
                if (this.motZ > (double)f6) {
                    this.motZ = f6;
                }
                this.fallDistance = 0.0f;
                if (this.motY < -0.15) {
                    this.motY = -0.15;
                }
                boolean bl2 = bl = this.isSneaking() && this instanceof EntityHuman;
                if (bl && this.motY < 0.0) {
                    this.motY = 0.0;
                }
            }
            this.move(this.motX, this.motY, this.motZ);
            if (this.positionChanged && this.f_()) {
                this.motY = 0.2;
            }
            this.motY -= 0.08;
            this.motY *= (double)0.98f;
            this.motX *= (double)f4;
            this.motZ *= (double)f4;
        }
        this.aY = this.aZ;
        d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f7 = MathHelper.sqrt(d * d + d2 * d2) * 4.0f;
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        this.aZ += (f7 - this.aZ) * 0.4f;
        this.ba += this.aZ;
    }

    public boolean f_() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.floor(this.boundingBox.b), n = MathHelper.floor(this.locZ));
        return n4 == Block.LADDER.id || n4 == Block.VINE.id;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("Health", (short)this.health);
        nBTTagCompound.setShort("HurtTime", (short)this.hurtTicks);
        nBTTagCompound.setShort("DeathTime", (short)this.deathTicks);
        nBTTagCompound.setShort("AttackTime", (short)this.attackTicks);
        if (!this.effects.isEmpty()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (MobEffect mobEffect : this.effects.values()) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.setByte("Id", (byte)mobEffect.getEffectId());
                nBTTagCompound2.setByte("Amplifier", (byte)mobEffect.getAmplifier());
                nBTTagCompound2.setInt("Duration", mobEffect.getDuration());
                nBTTagList.add(nBTTagCompound2);
            }
            nBTTagCompound.set("ActiveEffects", nBTTagList);
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        if (this.health < Short.MIN_VALUE) {
            this.health = Short.MIN_VALUE;
        }
        this.health = nBTTagCompound.getShort("Health");
        if (!nBTTagCompound.hasKey("Health")) {
            this.health = this.getMaxHealth();
        }
        this.hurtTicks = nBTTagCompound.getShort("HurtTime");
        this.deathTicks = nBTTagCompound.getShort("DeathTime");
        this.attackTicks = nBTTagCompound.getShort("AttackTime");
        if (nBTTagCompound.hasKey("ActiveEffects")) {
            NBTTagList nBTTagList = nBTTagCompound.getList("ActiveEffects");
            for (int i = 0; i < nBTTagList.size(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
                byte by = nBTTagCompound2.getByte("Id");
                byte by2 = nBTTagCompound2.getByte("Amplifier");
                int n = nBTTagCompound2.getInt("Duration");
                this.effects.put(Integer.valueOf(by), new MobEffect(by, n, by2));
            }
        }
    }

    public boolean isAlive() {
        return !this.dead && this.health > 0;
    }

    public boolean aU() {
        return false;
    }

    public void f(float f) {
        this.bs = f;
    }

    public void d(boolean bl) {
        this.bu = bl;
    }

    public void d() {
        List list;
        if (this.bE > 0) {
            --this.bE;
        }
        if (this.bi > 0) {
            double d = this.locX + (this.bj - this.locX) / (double)this.bi;
            double d2 = this.locY + (this.bk - this.locY) / (double)this.bi;
            double d3 = this.locZ + (this.bl - this.locZ) / (double)this.bi;
            double d4 = MathHelper.g(this.bm - (double)this.yaw);
            this.yaw = (float)((double)this.yaw + d4 / (double)this.bi);
            this.pitch = (float)((double)this.pitch + (this.bn - (double)this.pitch) / (double)this.bi);
            --this.bi;
            this.setPosition(d, d2, d3);
            this.b(this.yaw, this.pitch);
        }
        if (Math.abs(this.motX) < 0.005) {
            this.motX = 0.0;
        }
        if (Math.abs(this.motY) < 0.005) {
            this.motY = 0.0;
        }
        if (Math.abs(this.motZ) < 0.005) {
            this.motZ = 0.0;
        }
        this.world.methodProfiler.a("ai");
        if (this.aX()) {
            this.bu = false;
            this.br = 0.0f;
            this.bs = 0.0f;
            this.bt = 0.0f;
        } else if (this.aW()) {
            if (this.aV()) {
                this.world.methodProfiler.a("newAi");
                this.bc();
                this.world.methodProfiler.b();
            } else {
                this.world.methodProfiler.a("oldAi");
                this.be();
                this.world.methodProfiler.b();
                this.as = this.yaw;
            }
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("jump");
        if (this.bu) {
            if (this.H() || this.J()) {
                this.motY += (double)0.04f;
            } else if (this.onGround && this.bE == 0) {
                this.aZ();
                this.bE = 10;
            }
        } else {
            this.bE = 0;
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("travel");
        this.br *= 0.98f;
        this.bs *= 0.98f;
        this.bt *= 0.9f;
        float f = this.aG;
        this.aG *= this.bs();
        this.e(this.br, this.bs);
        this.aG = f;
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("push");
        if (!this.world.isStatic && (list = this.world.getEntities(this, this.boundingBox.grow(0.2f, 0.0, 0.2f))) != null && !list.isEmpty()) {
            for (Entity entity : list) {
                if (!entity.M()) continue;
                entity.collide(this);
            }
        }
        this.world.methodProfiler.b();
    }

    protected boolean aV() {
        return false;
    }

    protected boolean aW() {
        return !this.world.isStatic;
    }

    protected boolean aX() {
        return this.health <= 0;
    }

    public boolean aY() {
        return false;
    }

    protected void aZ() {
        this.motY = 0.42f;
        if (this.hasEffect(MobEffectList.JUMP)) {
            this.motY += (double)((float)(this.getEffect(MobEffectList.JUMP).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.yaw * ((float)Math.PI / 180);
            this.motX -= (double)(MathHelper.sin(f) * 0.2f);
            this.motZ += (double)(MathHelper.cos(f) * 0.2f);
        }
        this.al = true;
    }

    protected boolean ba() {
        return true;
    }

    protected void bb() {
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        if (entityHuman != null) {
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locY - this.locY;
            double d3 = entityHuman.locZ - this.locZ;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (this.ba() && d4 > 16384.0) {
                this.die();
            }
            if (this.bq > 600 && this.random.nextInt(800) == 0 && d4 > 1024.0 && this.ba()) {
                this.die();
            } else if (d4 < 1024.0) {
                this.bq = 0;
            }
        }
    }

    protected void bc() {
        ++this.bq;
        this.world.methodProfiler.a("checkDespawn");
        this.bb();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("sensing");
        this.bA.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("targetSelector");
        this.targetSelector.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("goalSelector");
        this.goalSelector.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("navigation");
        this.navigation.e();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("mob tick");
        this.bd();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("controls");
        this.world.methodProfiler.a("move");
        this.moveController.c();
        this.world.methodProfiler.c("look");
        this.lookController.a();
        this.world.methodProfiler.c("jump");
        this.jumpController.b();
        this.world.methodProfiler.b();
        this.world.methodProfiler.b();
    }

    protected void bd() {
    }

    protected void be() {
        ++this.bq;
        this.bb();
        this.br = 0.0f;
        this.bs = 0.0f;
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            EntityHuman entityHuman = this.world.findNearbyPlayer(this, f);
            if (entityHuman != null) {
                this.bF = entityHuman;
                this.bx = 10 + this.random.nextInt(20);
            } else {
                this.bt = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.bF != null) {
            this.a(this.bF, 10.0f, (float)this.bf());
            if (this.bx-- <= 0 || this.bF.dead || this.bF.e(this) > (double)(f * f)) {
                this.bF = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.bt = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yaw += this.bt;
            this.pitch = this.bv;
        }
        boolean bl = this.H();
        boolean bl2 = this.J();
        if (bl || bl2) {
            this.bu = this.random.nextFloat() < 0.8f;
        }
    }

    public int bf() {
        return 40;
    }

    public void a(Entity entity, float f, float f2) {
        double d;
        double d2 = entity.locX - this.locX;
        double d3 = entity.locZ - this.locZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            d = this.locY + (double)this.getHeadHeight() - (entityLiving.locY + (double)entityLiving.getHeadHeight());
        } else {
            d = (entity.boundingBox.b + entity.boundingBox.e) / 2.0 - (this.locY + (double)this.getHeadHeight());
        }
        double d4 = MathHelper.sqrt(d2 * d2 + d3 * d3);
        float f3 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d, d4) * 180.0 / 3.1415927410125732));
        this.pitch = -this.b(this.pitch, f4, f2);
        this.yaw = this.b(this.yaw, f3, f);
    }

    private float b(float f, float f2, float f3) {
        float f4 = MathHelper.g(f2 - f);
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    public boolean canSpawn() {
        return this.world.b(this.boundingBox) && this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox);
    }

    protected void C() {
        this.damageEntity(DamageSource.OUT_OF_WORLD, 4);
    }

    public Vec3D Z() {
        return this.i(1.0f);
    }

    public Vec3D i(float f) {
        if (f == 1.0f) {
            float f2 = MathHelper.cos(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f3 = MathHelper.sin(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = -MathHelper.cos(-this.pitch * ((float)Math.PI / 180));
            float f5 = MathHelper.sin(-this.pitch * ((float)Math.PI / 180));
            return Vec3D.a().create(f3 * f4, f5, f2 * f4);
        }
        float f6 = this.lastPitch + (this.pitch - this.lastPitch) * f;
        float f7 = this.lastYaw + (this.yaw - this.lastYaw) * f;
        float f8 = MathHelper.cos(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f9 = MathHelper.sin(-f7 * ((float)Math.PI / 180) - (float)Math.PI);
        float f10 = -MathHelper.cos(-f6 * ((float)Math.PI / 180));
        float f11 = MathHelper.sin(-f6 * ((float)Math.PI / 180));
        return Vec3D.a().create(f9 * f10, f11, f8 * f10);
    }

    public int bl() {
        return 4;
    }

    public boolean isSleeping() {
        return false;
    }

    protected void bo() {
        int n;
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n2);
            if (mobEffect.tick(this) || this.world.isStatic) continue;
            iterator.remove();
            this.c(mobEffect);
        }
        if (this.updateEffects) {
            if (!this.world.isStatic) {
                if (this.effects.isEmpty()) {
                    this.datawatcher.watch(8, 0);
                } else {
                    int n3 = PotionBrewer.a(this.effects.values());
                    this.datawatcher.watch(8, n3);
                }
            }
            this.updateEffects = false;
        }
        if (this.random.nextBoolean() && (n = this.datawatcher.getInt(8)) > 0) {
            double d = (double)(n >> 16 & 0xFF) / 255.0;
            double d2 = (double)(n >> 8 & 0xFF) / 255.0;
            double d3 = (double)(n >> 0 & 0xFF) / 255.0;
            this.world.a("mobSpell", this.locX + (this.random.nextDouble() - 0.5) * (double)this.width, this.locY + this.random.nextDouble() * (double)this.length - (double)this.height, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.width, d, d2, d3);
        }
    }

    public void bp() {
        Iterator iterator = this.effects.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            MobEffect mobEffect = (MobEffect)this.effects.get(n);
            if (this.world.isStatic) continue;
            iterator.remove();
            this.c(mobEffect);
        }
    }

    public Collection getEffects() {
        return this.effects.values();
    }

    public boolean hasEffect(MobEffectList mobEffectList) {
        return this.effects.containsKey(mobEffectList.id);
    }

    public MobEffect getEffect(MobEffectList mobEffectList) {
        return (MobEffect)this.effects.get(mobEffectList.id);
    }

    public void addEffect(MobEffect mobEffect) {
        if (!this.e(mobEffect)) {
            return;
        }
        if (this.effects.containsKey(mobEffect.getEffectId())) {
            ((MobEffect)this.effects.get(mobEffect.getEffectId())).a(mobEffect);
            this.b((MobEffect)this.effects.get(mobEffect.getEffectId()));
        } else {
            this.effects.put(mobEffect.getEffectId(), mobEffect);
            this.a(mobEffect);
        }
    }

    public boolean e(MobEffect mobEffect) {
        int n;
        return this.getMonsterType() != EnumMonsterType.UNDEAD || (n = mobEffect.getEffectId()) != MobEffectList.REGENERATION.id && n != MobEffectList.POISON.id;
    }

    public boolean br() {
        return this.getMonsterType() == EnumMonsterType.UNDEAD;
    }

    protected void a(MobEffect mobEffect) {
        this.updateEffects = true;
    }

    protected void b(MobEffect mobEffect) {
        this.updateEffects = true;
    }

    protected void c(MobEffect mobEffect) {
        this.updateEffects = true;
    }

    protected float bs() {
        float f = 1.0f;
        if (this.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            f *= 1.0f + 0.2f * (float)(this.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier() + 1);
        }
        if (this.hasEffect(MobEffectList.SLOWER_MOVEMENT)) {
            f *= 1.0f - 0.15f * (float)(this.getEffect(MobEffectList.SLOWER_MOVEMENT).getAmplifier() + 1);
        }
        return f;
    }

    public void enderTeleportTo(double d, double d2, double d3) {
        this.setPositionRotation(d, d2, d3, this.yaw, this.pitch);
    }

    public boolean isBaby() {
        return false;
    }

    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEFINED;
    }

    public void a(ItemStack itemStack) {
        this.world.makeSound(this, "random.break", 0.8f, 0.8f + this.world.random.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            Vec3D vec3D = Vec3D.a().create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
            Vec3D vec3D2 = Vec3D.a().create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
            vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
            vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
            vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ);
            this.world.a("iconcrack_" + itemStack.getItem().id, vec3D2.a, vec3D2.b, vec3D2.c, vec3D.a, vec3D.b + 0.05, vec3D.c);
        }
    }
}

