/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.EntityIronGolem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityVillager;
import net.minecraft.server.MathHelper;
import net.minecraft.server.Vec3D;
import net.minecraft.server.VillageAggressor;
import net.minecraft.server.VillageDoor;
import net.minecraft.server.World;

public class Village {
    private final World world;
    private final List doors = new ArrayList();
    private final ChunkCoordinates c = new ChunkCoordinates(0, 0, 0);
    private final ChunkCoordinates center = new ChunkCoordinates(0, 0, 0);
    private int size = 0;
    private int f = 0;
    private int time = 0;
    private int population = 0;
    private List i = new ArrayList();
    private int j = 0;

    public Village(World world) {
        this.world = world;
    }

    public void tick(int n) {
        Vec3D vec3D;
        int n2;
        this.time = n;
        this.k();
        this.j();
        if (n % 20 == 0) {
            this.i();
        }
        if (n % 30 == 0) {
            this.countPopulation();
        }
        if (this.j < (n2 = this.population / 16) && this.doors.size() > 20 && this.world.random.nextInt(7000) == 0 && (vec3D = this.a(MathHelper.d(this.center.x), MathHelper.d(this.center.y), MathHelper.d(this.center.z), 2, 4, 2)) != null) {
            EntityIronGolem entityIronGolem = new EntityIronGolem(this.world);
            entityIronGolem.setPosition(vec3D.a, vec3D.b, vec3D.c);
            this.world.addEntity(entityIronGolem);
            ++this.j;
        }
    }

    private Vec3D a(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < 10; ++i) {
            int n7;
            int n8;
            int n9 = n + this.world.random.nextInt(16) - 8;
            if (!this.a(n9, n8 = n2 + this.world.random.nextInt(6) - 3, n7 = n3 + this.world.random.nextInt(16) - 8) || !this.b(n9, n8, n7, n4, n5, n6)) continue;
            return Vec3D.a().create(n9, n8, n7);
        }
        return null;
    }

    private boolean b(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.world.t(n, n2 - 1, n3)) {
            return false;
        }
        int n7 = n - n4 / 2;
        int n8 = n3 - n6 / 2;
        for (int i = n7; i < n7 + n4; ++i) {
            for (int j = n2; j < n2 + n5; ++j) {
                for (int k = n8; k < n8 + n6; ++k) {
                    if (!this.world.s(i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void countPopulation() {
        List list = this.world.a(EntityIronGolem.class, AxisAlignedBB.a().a(this.center.x - this.size, this.center.y - 4, this.center.z - this.size, this.center.x + this.size, this.center.y + 4, this.center.z + this.size));
        this.j = list.size();
    }

    private void i() {
        List list = this.world.a(EntityVillager.class, AxisAlignedBB.a().a(this.center.x - this.size, this.center.y - 4, this.center.z - this.size, this.center.x + this.size, this.center.y + 4, this.center.z + this.size));
        this.population = list.size();
    }

    public ChunkCoordinates getCenter() {
        return this.center;
    }

    public int getSize() {
        return this.size;
    }

    public int getDoorCount() {
        return this.doors.size();
    }

    public int d() {
        return this.time - this.f;
    }

    public int getPopulationCount() {
        return this.population;
    }

    public boolean a(int n, int n2, int n3) {
        return this.center.e(n, n2, n3) < (float)(this.size * this.size);
    }

    public List getDoors() {
        return this.doors;
    }

    public VillageDoor b(int n, int n2, int n3) {
        VillageDoor villageDoor = null;
        int n4 = Integer.MAX_VALUE;
        for (VillageDoor villageDoor2 : this.doors) {
            int n5 = villageDoor2.b(n, n2, n3);
            if (n5 >= n4) continue;
            villageDoor = villageDoor2;
            n4 = n5;
        }
        return villageDoor;
    }

    public VillageDoor c(int n, int n2, int n3) {
        VillageDoor villageDoor = null;
        int n4 = Integer.MAX_VALUE;
        for (VillageDoor villageDoor2 : this.doors) {
            int n5 = villageDoor2.b(n, n2, n3);
            n5 = n5 > 256 ? (n5 *= 1000) : villageDoor2.f();
            if (n5 >= n4) continue;
            villageDoor = villageDoor2;
            n4 = n5;
        }
        return villageDoor;
    }

    public VillageDoor e(int n, int n2, int n3) {
        if (this.center.e(n, n2, n3) > (float)(this.size * this.size)) {
            return null;
        }
        for (VillageDoor villageDoor : this.doors) {
            if (villageDoor.locX != n || villageDoor.locZ != n3 || Math.abs(villageDoor.locY - n2) > 1) continue;
            return villageDoor;
        }
        return null;
    }

    public void addDoor(VillageDoor villageDoor) {
        this.doors.add(villageDoor);
        this.c.x += villageDoor.locX;
        this.c.y += villageDoor.locY;
        this.c.z += villageDoor.locZ;
        this.l();
        this.f = villageDoor.addedTime;
    }

    public boolean isAbandoned() {
        return this.doors.isEmpty();
    }

    public void a(EntityLiving entityLiving) {
        for (VillageAggressor villageAggressor : this.i) {
            if (villageAggressor.a != entityLiving) continue;
            villageAggressor.b = this.time;
            return;
        }
        this.i.add(new VillageAggressor(this, entityLiving, this.time));
    }

    public EntityLiving b(EntityLiving entityLiving) {
        double d = Double.MAX_VALUE;
        VillageAggressor villageAggressor = null;
        for (VillageAggressor villageAggressor2 : this.i) {
            double d2 = villageAggressor2.a.e(entityLiving);
            if (d2 > d) continue;
            villageAggressor = villageAggressor2;
            d = d2;
        }
        return villageAggressor != null ? villageAggressor.a : null;
    }

    private void j() {
        Iterator iterator = this.i.iterator();
        while (iterator.hasNext()) {
            VillageAggressor villageAggressor = (VillageAggressor)iterator.next();
            if (villageAggressor.a.isAlive() && Math.abs(this.time - villageAggressor.b) <= 300) continue;
            iterator.remove();
        }
    }

    private void k() {
        boolean bl = false;
        boolean bl2 = this.world.random.nextInt(50) == 0;
        Iterator iterator = this.doors.iterator();
        while (iterator.hasNext()) {
            VillageDoor villageDoor = (VillageDoor)iterator.next();
            if (bl2) {
                villageDoor.d();
            }
            if (this.isDoor(villageDoor.locX, villageDoor.locY, villageDoor.locZ) && Math.abs(this.time - villageDoor.addedTime) <= 1200) continue;
            this.c.x -= villageDoor.locX;
            this.c.y -= villageDoor.locY;
            this.c.z -= villageDoor.locZ;
            bl = true;
            villageDoor.g = true;
            iterator.remove();
        }
        if (bl) {
            this.l();
        }
    }

    private boolean isDoor(int n, int n2, int n3) {
        int n4 = this.world.getTypeId(n, n2, n3);
        if (n4 <= 0) {
            return false;
        }
        return n4 == Block.WOODEN_DOOR.id;
    }

    private void l() {
        int n = this.doors.size();
        if (n == 0) {
            this.center.b(0, 0, 0);
            this.size = 0;
            return;
        }
        this.center.b(this.c.x / n, this.c.y / n, this.c.z / n);
        int n2 = 0;
        for (VillageDoor villageDoor : this.doors) {
            n2 = Math.max(villageDoor.b(this.center.x, this.center.y, this.center.z), n2);
        }
        this.size = Math.max(32, (int)Math.sqrt(n2) + 1);
    }
}

