/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagByte;
import net.minecraft.server.NBTTagByteArray;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagInt;
import net.minecraft.server.NBTTagIntArray;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NBTTagLong;
import net.minecraft.server.NBTTagShort;
import net.minecraft.server.NBTTagString;

public class NBTTagCompound
extends NBTBase {
    private Map map = new HashMap();

    public NBTTagCompound() {
        super("");
    }

    public NBTTagCompound(String string) {
        super(string);
    }

    void write(DataOutput dataOutput) {
        for (NBTBase nBTBase : this.map.values()) {
            NBTBase.a(nBTBase, dataOutput);
        }
        dataOutput.writeByte(0);
    }

    void load(DataInput dataInput) {
        NBTBase nBTBase;
        this.map.clear();
        while ((nBTBase = NBTBase.b(dataInput)).getTypeId() != 0) {
            this.map.put(nBTBase.getName(), nBTBase);
        }
    }

    public Collection c() {
        return this.map.values();
    }

    public byte getTypeId() {
        return 10;
    }

    public void set(String string, NBTBase nBTBase) {
        this.map.put(string, nBTBase.setName(string));
    }

    public void setByte(String string, byte by) {
        this.map.put(string, new NBTTagByte(string, by));
    }

    public void setShort(String string, short s) {
        this.map.put(string, new NBTTagShort(string, s));
    }

    public void setInt(String string, int n) {
        this.map.put(string, new NBTTagInt(string, n));
    }

    public void setLong(String string, long l) {
        this.map.put(string, new NBTTagLong(string, l));
    }

    public void setFloat(String string, float f) {
        this.map.put(string, new NBTTagFloat(string, f));
    }

    public void setDouble(String string, double d) {
        this.map.put(string, new NBTTagDouble(string, d));
    }

    public void setString(String string, String string2) {
        this.map.put(string, new NBTTagString(string, string2));
    }

    public void setByteArray(String string, byte[] byArray) {
        this.map.put(string, new NBTTagByteArray(string, byArray));
    }

    public void setIntArray(String string, int[] nArray) {
        this.map.put(string, new NBTTagIntArray(string, nArray));
    }

    public void setCompound(String string, NBTTagCompound nBTTagCompound) {
        this.map.put(string, nBTTagCompound.setName(string));
    }

    public void setBoolean(String string, boolean bl) {
        this.setByte(string, bl ? (byte)1 : 0);
    }

    public NBTBase get(String string) {
        return (NBTBase)this.map.get(string);
    }

    public boolean hasKey(String string) {
        return this.map.containsKey(string);
    }

    public byte getByte(String string) {
        if (!this.map.containsKey(string)) {
            return 0;
        }
        return ((NBTTagByte)this.map.get((Object)string)).data;
    }

    public short getShort(String string) {
        if (!this.map.containsKey(string)) {
            return 0;
        }
        return ((NBTTagShort)this.map.get((Object)string)).data;
    }

    public int getInt(String string) {
        if (!this.map.containsKey(string)) {
            return 0;
        }
        return ((NBTTagInt)this.map.get((Object)string)).data;
    }

    public long getLong(String string) {
        if (!this.map.containsKey(string)) {
            return 0L;
        }
        return ((NBTTagLong)this.map.get((Object)string)).data;
    }

    public float getFloat(String string) {
        if (!this.map.containsKey(string)) {
            return 0.0f;
        }
        return ((NBTTagFloat)this.map.get((Object)string)).data;
    }

    public double getDouble(String string) {
        if (!this.map.containsKey(string)) {
            return 0.0;
        }
        return ((NBTTagDouble)this.map.get((Object)string)).data;
    }

    public String getString(String string) {
        if (!this.map.containsKey(string)) {
            return "";
        }
        return ((NBTTagString)this.map.get((Object)string)).data;
    }

    public byte[] getByteArray(String string) {
        if (!this.map.containsKey(string)) {
            return new byte[0];
        }
        return ((NBTTagByteArray)this.map.get((Object)string)).data;
    }

    public int[] getIntArray(String string) {
        if (!this.map.containsKey(string)) {
            return new int[0];
        }
        return ((NBTTagIntArray)this.map.get((Object)string)).data;
    }

    public NBTTagCompound getCompound(String string) {
        if (!this.map.containsKey(string)) {
            return new NBTTagCompound(string);
        }
        return (NBTTagCompound)this.map.get(string);
    }

    public NBTTagList getList(String string) {
        if (!this.map.containsKey(string)) {
            return new NBTTagList(string);
        }
        return (NBTTagList)this.map.get(string);
    }

    public boolean getBoolean(String string) {
        return this.getByte(string) != 0;
    }

    public String toString() {
        return "" + this.map.size() + " entries";
    }

    public NBTBase clone() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound(this.getName());
        for (String string : this.map.keySet()) {
            nBTTagCompound.set(string, ((NBTBase)this.map.get(string)).clone());
        }
        return nBTTagCompound;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)object;
            return ((Object)this.map.entrySet()).equals(nBTTagCompound.map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ ((Object)this.map).hashCode();
    }
}

