/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityChicken;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowOwner;
import net.minecraft.server.PathfinderGoalJumpOnBlock;
import net.minecraft.server.PathfinderGoalLeapAtTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalOzelotAttack;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntityOcelot
extends EntityTameableAnimal {
    private PathfinderGoalTempt e;

    public EntityOcelot(World world) {
        super(world);
        this.texture = "/mob/ozelot.png";
        this.a(0.6f, 0.8f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, this.d);
        this.e = new PathfinderGoalTempt(this, 0.18f, Item.RAW_FISH.id, true);
        this.goalSelector.a(3, this.e);
        this.goalSelector.a(4, new PathfinderGoalAvoidPlayer(this, EntityHuman.class, 16.0f, 0.23f, 0.4f));
        this.goalSelector.a(5, new PathfinderGoalFollowOwner(this, 0.3f, 10.0f, 5.0f));
        this.goalSelector.a(6, new PathfinderGoalJumpOnBlock(this, 0.4f));
        this.goalSelector.a(7, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.goalSelector.a(8, new PathfinderGoalOzelotAttack(this));
        this.goalSelector.a(9, new PathfinderGoalBreed(this, 0.23f));
        this.goalSelector.a(10, new PathfinderGoalRandomStroll(this, 0.23f));
        this.goalSelector.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.targetSelector.a(1, new PathfinderGoalRandomTargetNonTamed(this, EntityChicken.class, 14.0f, 750, false));
    }

    protected void a() {
        super.a();
        this.datawatcher.a(18, (byte)0);
    }

    public void bd() {
        if (this.getControllerMove().a()) {
            float f = this.getControllerMove().b();
            if (f == 0.18f) {
                this.setSneaking(true);
                this.setSprinting(false);
            } else if (f == 0.4f) {
                this.setSneaking(false);
                this.setSprinting(true);
            } else {
                this.setSneaking(false);
                this.setSprinting(false);
            }
        } else {
            this.setSneaking(false);
            this.setSprinting(false);
        }
    }

    protected boolean ba() {
        return !this.isTamed();
    }

    public boolean aV() {
        return true;
    }

    public int getMaxHealth() {
        return 10;
    }

    protected void a(float f) {
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("CatType", this.getCatType());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setCatType(nBTTagCompound.getInt("CatType"));
    }

    protected String aQ() {
        if (this.isTamed()) {
            if (this.s()) {
                return "mob.cat.purr";
            }
            if (this.random.nextInt(4) == 0) {
                return "mob.cat.purreow";
            }
            return "mob.cat.meow";
        }
        return "";
    }

    protected String aR() {
        return "mob.cat.hitt";
    }

    protected String aS() {
        return "mob.cat.hitt";
    }

    protected float aP() {
        return 0.4f;
    }

    protected int getLootId() {
        return Item.LEATHER.id;
    }

    public boolean k(Entity entity) {
        return entity.damageEntity(DamageSource.mobAttack(this), 3);
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.d.a(false);
        return super.damageEntity(damageSource, n);
    }

    protected void dropDeathLoot(boolean bl, int n) {
    }

    public boolean c(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (this.isTamed()) {
            if (entityHuman.name.equalsIgnoreCase(this.getOwnerName()) && !this.world.isStatic && !this.b(itemStack)) {
                this.d.a(!this.isSitting());
            }
        } else if (this.e.f() && itemStack != null && itemStack.id == Item.RAW_FISH.id && entityHuman.e(this) < 9.0) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
            }
            if (itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            if (!this.world.isStatic) {
                if (this.random.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.setCatType(1 + this.world.random.nextInt(3));
                    this.setOwnerName(entityHuman.name);
                    this.e(true);
                    this.d.a(true);
                    this.world.broadcastEntityEffect(this, (byte)7);
                } else {
                    this.e(false);
                    this.world.broadcastEntityEffect(this, (byte)6);
                }
            }
            return true;
        }
        return super.c(entityHuman);
    }

    public EntityAnimal createChild(EntityAnimal entityAnimal) {
        EntityOcelot entityOcelot = new EntityOcelot(this.world);
        if (this.isTamed()) {
            entityOcelot.setOwnerName(this.getOwnerName());
            entityOcelot.setTamed(true);
            entityOcelot.setCatType(this.getCatType());
        }
        return entityOcelot;
    }

    public boolean b(ItemStack itemStack) {
        return itemStack != null && itemStack.id == Item.RAW_FISH.id;
    }

    public boolean mate(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityOcelot)) {
            return false;
        }
        EntityOcelot entityOcelot = (EntityOcelot)entityAnimal;
        if (!entityOcelot.isTamed()) {
            return false;
        }
        return this.s() && entityOcelot.s();
    }

    public int getCatType() {
        return this.datawatcher.getByte(18);
    }

    public void setCatType(int n) {
        this.datawatcher.watch(18, (byte)n);
    }

    public boolean canSpawn() {
        if (this.world.random.nextInt(3) == 0) {
            return false;
        }
        if (this.world.b(this.boundingBox) && this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox)) {
            int n = MathHelper.floor(this.locX);
            int n2 = MathHelper.floor(this.boundingBox.b);
            int n3 = MathHelper.floor(this.locZ);
            if (n2 < 63) {
                return false;
            }
            int n4 = this.world.getTypeId(n, n2 - 1, n3);
            if (n4 == Block.GRASS.id || n4 == Block.LEAVES.id) {
                return true;
            }
        }
        return false;
    }

    public String getLocalizedName() {
        if (this.isTamed()) {
            return "entity.Cat.name";
        }
        return super.getLocalizedName();
    }
}

