/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockBed;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerPlayer;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.EntityWolf;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumBedResult;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.FoodMetaData;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IInventory;
import net.minecraft.server.IMerchant;
import net.minecraft.server.InventoryEnderChest;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleLanguage;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PlayerAbilities;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.Statistic;
import net.minecraft.server.StatisticList;
import net.minecraft.server.TileEntityBrewingStand;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityHuman
extends EntityLiving
implements ICommandListener {
    public PlayerInventory inventory = new PlayerInventory(this);
    private InventoryEnderChest enderChest = new InventoryEnderChest();
    public Container defaultContainer;
    public Container activeContainer;
    protected FoodMetaData foodData = new FoodMetaData();
    protected int bC = 0;
    public byte bD = 0;
    public int bE = 0;
    public float bF;
    public float bG;
    public boolean bH = false;
    public int bI = 0;
    public String name;
    public int dimension;
    public int bL = 0;
    public double bM;
    public double bN;
    public double bO;
    public double bP;
    public double bQ;
    public double bR;
    protected boolean sleeping;
    public ChunkCoordinates bT;
    private int sleepTicks;
    public float bU;
    public float bV;
    private ChunkCoordinates c;
    private ChunkCoordinates d;
    public int bW = 20;
    protected boolean bX = false;
    public float bY;
    public PlayerAbilities abilities = new PlayerAbilities();
    public int expLevel;
    public int expTotal;
    public float exp;
    private ItemStack e;
    private int f;
    protected float cd = 0.1f;
    protected float ce = 0.02f;
    public EntityFishingHook hookedFish = null;

    public EntityHuman(World world) {
        super(world);
        this.activeContainer = this.defaultContainer = new ContainerPlayer(this.inventory, !world.isStatic);
        this.height = 1.62f;
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        this.setPositionRotation((double)chunkCoordinates.x + 0.5, chunkCoordinates.y + 1, (double)chunkCoordinates.z + 0.5, 0.0f, 0.0f);
        this.aC = "humanoid";
        this.aB = 180.0f;
        this.maxFireTicks = 20;
        this.texture = "/mob/char.png";
    }

    public int getMaxHealth() {
        return 20;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, (byte)0);
        this.datawatcher.a(17, (byte)0);
    }

    public boolean bw() {
        return this.e != null;
    }

    public void by() {
        if (this.e != null) {
            this.e.b(this.world, this, this.f);
        }
        this.bz();
    }

    public void bz() {
        this.e = null;
        this.f = 0;
        if (!this.world.isStatic) {
            this.c(false);
        }
    }

    public boolean aY() {
        return this.bw() && Item.byId[this.e.id].b(this.e) == EnumAnimation.d;
    }

    public void h_() {
        if (this.e != null) {
            ItemStack itemStack = this.inventory.getItemInHand();
            if (itemStack == this.e) {
                if (this.f <= 25 && this.f % 4 == 0) {
                    this.c(itemStack, 5);
                }
                if (--this.f == 0 && !this.world.isStatic) {
                    this.o();
                }
            } else {
                this.bz();
            }
        }
        if (this.bL > 0) {
            --this.bL;
        }
        if (this.isSleeping()) {
            ++this.sleepTicks;
            if (this.sleepTicks > 100) {
                this.sleepTicks = 100;
            }
            if (!this.world.isStatic) {
                if (!this.l()) {
                    this.a(true, true, false);
                } else if (this.world.s()) {
                    this.a(false, true, true);
                }
            }
        } else if (this.sleepTicks > 0) {
            ++this.sleepTicks;
            if (this.sleepTicks >= 110) {
                this.sleepTicks = 0;
            }
        }
        super.h_();
        if (!this.world.isStatic && this.activeContainer != null && !this.activeContainer.c(this)) {
            this.closeInventory();
            this.activeContainer = this.defaultContainer;
        }
        if (this.isBurning() && this.abilities.isInvulnerable) {
            this.extinguish();
        }
        this.bM = this.bP;
        this.bN = this.bQ;
        this.bO = this.bR;
        double d = this.locX - this.bP;
        double d2 = this.locY - this.bQ;
        double d3 = this.locZ - this.bR;
        double d4 = 10.0;
        if (d > d4) {
            this.bM = this.bP = this.locX;
        }
        if (d3 > d4) {
            this.bO = this.bR = this.locZ;
        }
        if (d2 > d4) {
            this.bN = this.bQ = this.locY;
        }
        if (d < -d4) {
            this.bM = this.bP = this.locX;
        }
        if (d3 < -d4) {
            this.bO = this.bR = this.locZ;
        }
        if (d2 < -d4) {
            this.bN = this.bQ = this.locY;
        }
        this.bP += d * 0.25;
        this.bR += d3 * 0.25;
        this.bQ += d2 * 0.25;
        this.a(StatisticList.k, 1);
        if (this.vehicle == null) {
            this.d = null;
        }
        if (!this.world.isStatic) {
            this.foodData.a(this);
        }
    }

    protected void c(ItemStack itemStack, int n) {
        if (itemStack.n() == EnumAnimation.c) {
            this.world.makeSound(this, "random.drink", 0.5f, this.world.random.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack.n() == EnumAnimation.b) {
            for (int i = 0; i < n; ++i) {
                Vec3D vec3D = Vec3D.a().create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
                Vec3D vec3D2 = Vec3D.a().create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
                vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
                vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ);
                this.world.a("iconcrack_" + itemStack.getItem().id, vec3D2.a, vec3D2.b, vec3D2.c, vec3D.a, vec3D.b + 0.05, vec3D.c);
            }
            this.world.makeSound(this, "random.eat", 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected void o() {
        if (this.e != null) {
            this.c(this.e, 16);
            int n = this.e.count;
            ItemStack itemStack = this.e.b(this.world, this);
            if (itemStack != this.e || itemStack != null && itemStack.count != n) {
                this.inventory.items[this.inventory.itemInHandIndex] = itemStack;
                if (itemStack.count == 0) {
                    this.inventory.items[this.inventory.itemInHandIndex] = null;
                }
            }
            this.bz();
        }
    }

    protected boolean aX() {
        return this.getHealth() <= 0 || this.isSleeping();
    }

    protected void closeInventory() {
        this.activeContainer = this.defaultContainer;
    }

    public void U() {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        super.U();
        this.bF = this.bG;
        this.bG = 0.0f;
        this.k(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    private int k() {
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            return 6 - (1 + this.getEffect(MobEffectList.FASTER_DIG).getAmplifier()) * 1;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            return 6 + (1 + this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier()) * 2;
        }
        return 6;
    }

    protected void be() {
        int n = this.k();
        if (this.bH) {
            ++this.bI;
            if (this.bI >= n) {
                this.bI = 0;
                this.bH = false;
            }
        } else {
            this.bI = 0;
        }
        this.aJ = (float)this.bI / (float)n;
    }

    public void d() {
        List list;
        if (this.bC > 0) {
            --this.bC;
        }
        if (this.world.difficulty == 0 && this.getHealth() < this.getMaxHealth() && this.ticksLived % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.k();
        this.bF = this.bG;
        super.d();
        this.aG = this.abilities.b();
        this.aH = this.ce;
        if (this.isSprinting()) {
            this.aG = (float)((double)this.aG + (double)this.abilities.b() * 0.3);
            this.aH = (float)((double)this.aH + (double)this.ce * 0.3);
        }
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        float f2 = (float)Math.atan(-this.motY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f2 = 0.0f;
        }
        this.bG += (f - this.bG) * 0.4f;
        this.aT += (f2 - this.aT) * 0.8f;
        if (this.getHealth() > 0 && (list = this.world.getEntities(this, this.boundingBox.grow(1.0, 0.0, 1.0))) != null) {
            for (Entity entity : list) {
                if (entity.dead) continue;
                this.o(entity);
            }
        }
    }

    private void o(Entity entity) {
        entity.b_(this);
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.a(0.2f, 0.2f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.motY = 0.1f;
        if (this.name.equals("Notch")) {
            this.a(new ItemStack(Item.APPLE, 1), true);
        }
        this.inventory.m();
        if (damageSource != null) {
            this.motX = -MathHelper.cos((this.aP + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motZ = -MathHelper.sin((this.aP + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motZ = 0.0;
            this.motX = 0.0;
        }
        this.height = 0.1f;
        this.a(StatisticList.y, 1);
    }

    public void c(Entity entity, int n) {
        this.bE += n;
        if (entity instanceof EntityHuman) {
            this.a(StatisticList.A, 1);
        } else {
            this.a(StatisticList.z, 1);
        }
    }

    protected int h(int n) {
        int n2 = EnchantmentManager.getOxygenEnchantmentLevel(this.inventory);
        if (n2 > 0 && this.random.nextInt(n2 + 1) > 0) {
            return n;
        }
        return super.h(n);
    }

    public EntityItem bB() {
        return this.a(this.inventory.splitStack(this.inventory.itemInHandIndex, 1), false);
    }

    public EntityItem drop(ItemStack itemStack) {
        return this.a(itemStack, false);
    }

    public EntityItem a(ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return null;
        }
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY - (double)0.3f + (double)this.getHeadHeight(), this.locZ, itemStack);
        entityItem.pickupDelay = 40;
        float f = 0.1f;
        if (bl) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX = -MathHelper.sin(f3) * f2;
            entityItem.motZ = MathHelper.cos(f3) * f2;
            entityItem.motY = 0.2f;
        } else {
            f = 0.3f;
            entityItem.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI) * f + 0.1f;
            f = 0.02f;
            float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX += Math.cos(f4) * (double)(f *= this.random.nextFloat());
            entityItem.motY += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            entityItem.motZ += Math.sin(f4) * (double)f;
        }
        this.a(entityItem);
        this.a(StatisticList.v, 1);
        return entityItem;
    }

    protected void a(EntityItem entityItem) {
        this.world.addEntity(entityItem);
    }

    public float a(Block block) {
        float f = this.inventory.a(block);
        int n = EnchantmentManager.getDigSpeedEnchantmentLevel(this.inventory);
        if (n > 0 && this.inventory.b(block)) {
            f += (float)(n * n + 1);
        }
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            f *= 1.0f + (float)(this.getEffect(MobEffectList.FASTER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            f *= 1.0f - (float)(this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.a(Material.WATER) && !EnchantmentManager.hasWaterWorkerEnchantment(this.inventory)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean b(Block block) {
        return this.inventory.b(block);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Inventory");
        this.inventory.b(nBTTagList);
        this.dimension = nBTTagCompound.getInt("Dimension");
        this.sleeping = nBTTagCompound.getBoolean("Sleeping");
        this.sleepTicks = nBTTagCompound.getShort("SleepTimer");
        this.exp = nBTTagCompound.getFloat("XpP");
        this.expLevel = nBTTagCompound.getInt("XpLevel");
        this.expTotal = nBTTagCompound.getInt("XpTotal");
        if (this.sleeping) {
            this.bT = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.a(true, true, false);
        }
        if (nBTTagCompound.hasKey("SpawnX") && nBTTagCompound.hasKey("SpawnY") && nBTTagCompound.hasKey("SpawnZ")) {
            this.c = new ChunkCoordinates(nBTTagCompound.getInt("SpawnX"), nBTTagCompound.getInt("SpawnY"), nBTTagCompound.getInt("SpawnZ"));
        }
        this.foodData.a(nBTTagCompound);
        this.abilities.b(nBTTagCompound);
        if (nBTTagCompound.hasKey("EnderItems")) {
            NBTTagList nBTTagList2 = nBTTagCompound.getList("EnderItems");
            this.enderChest.a(nBTTagList2);
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.set("Inventory", this.inventory.a(new NBTTagList()));
        nBTTagCompound.setInt("Dimension", this.dimension);
        nBTTagCompound.setBoolean("Sleeping", this.sleeping);
        nBTTagCompound.setShort("SleepTimer", (short)this.sleepTicks);
        nBTTagCompound.setFloat("XpP", this.exp);
        nBTTagCompound.setInt("XpLevel", this.expLevel);
        nBTTagCompound.setInt("XpTotal", this.expTotal);
        if (this.c != null) {
            nBTTagCompound.setInt("SpawnX", this.c.x);
            nBTTagCompound.setInt("SpawnY", this.c.y);
            nBTTagCompound.setInt("SpawnZ", this.c.z);
        }
        this.foodData.b(nBTTagCompound);
        this.abilities.a(nBTTagCompound);
        nBTTagCompound.set("EnderItems", this.enderChest.g());
    }

    public void openContainer(IInventory iInventory) {
    }

    public void startEnchanting(int n, int n2, int n3) {
    }

    public void startCrafting(int n, int n2, int n3) {
    }

    public void receive(Entity entity, int n) {
    }

    public float getHeadHeight() {
        return 0.12f;
    }

    protected void d_() {
        this.height = 1.62f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.abilities.isInvulnerable && !damageSource.ignoresInvulnerability()) {
            return false;
        }
        this.bq = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        if (this.isSleeping() && !this.world.isStatic) {
            this.a(true, true, false);
        }
        Entity entity = damageSource.getEntity();
        if (damageSource.n()) {
            if (this.world.difficulty == 0) {
                n = 0;
            }
            if (this.world.difficulty == 1) {
                n = n / 2 + 1;
            }
            if (this.world.difficulty == 3) {
                n = n * 3 / 2;
            }
        }
        if (n == 0) {
            return false;
        }
        Entity entity2 = damageSource.getEntity();
        if (entity2 instanceof EntityArrow && ((EntityArrow)entity2).shooter != null) {
            entity2 = ((EntityArrow)entity2).shooter;
        }
        if (entity2 instanceof EntityLiving) {
            this.a((EntityLiving)entity2, false);
        }
        this.a(StatisticList.x, n);
        return super.damageEntity(damageSource, n);
    }

    protected int c(DamageSource damageSource, int n) {
        int n2 = super.c(damageSource, n);
        if (n2 <= 0) {
            return 0;
        }
        int n3 = EnchantmentManager.a(this.inventory, damageSource);
        if (n3 > 20) {
            n3 = 20;
        }
        if (n3 > 0 && n3 <= 20) {
            int n4 = 25 - n3;
            int n5 = n2 * n4 + this.aM;
            n2 = n5 / 25;
            this.aM = n5 % 25;
        }
        return n2;
    }

    protected boolean h() {
        return false;
    }

    protected void a(EntityLiving entityLiving, boolean bl) {
        Object object;
        if (entityLiving instanceof EntityCreeper || entityLiving instanceof EntityGhast) {
            return;
        }
        if (entityLiving instanceof EntityWolf && ((EntityTameableAnimal)(object = (EntityWolf)entityLiving)).isTamed() && this.name.equals(((EntityTameableAnimal)object).getOwnerName())) {
            return;
        }
        if (entityLiving instanceof EntityHuman && !this.h()) {
            return;
        }
        object = this.world.a(EntityWolf.class, AxisAlignedBB.a().a(this.locX, this.locY, this.locZ, this.locX + 1.0, this.locY + 1.0, this.locZ + 1.0).grow(16.0, 4.0, 16.0));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            EntityWolf entityWolf = (EntityWolf)iterator.next();
            if (!entityWolf.isTamed() || entityWolf.m() != null || !this.name.equals(entityWolf.getOwnerName()) || bl && entityWolf.isSitting()) continue;
            entityWolf.setSitting(false);
            entityWolf.setTarget(entityLiving);
        }
    }

    protected void k(int n) {
        this.inventory.g(n);
    }

    public int aO() {
        return this.inventory.l();
    }

    protected void d(DamageSource damageSource, int n) {
        if (!damageSource.ignoresArmor() && this.aY()) {
            n = 1 + n >> 1;
        }
        n = this.b(damageSource, n);
        n = this.c(damageSource, n);
        this.j(damageSource.d());
        this.health -= n;
    }

    public void openFurnace(TileEntityFurnace tileEntityFurnace) {
    }

    public void openDispenser(TileEntityDispenser tileEntityDispenser) {
    }

    public void a(TileEntitySign tileEntitySign) {
    }

    public void openBrewingStand(TileEntityBrewingStand tileEntityBrewingStand) {
    }

    public void openTrade(IMerchant iMerchant) {
    }

    public void c(ItemStack itemStack) {
    }

    public boolean m(Entity entity) {
        if (entity.c(this)) {
            return true;
        }
        ItemStack itemStack = this.bC();
        if (itemStack != null && entity instanceof EntityLiving) {
            if (this.abilities.canInstantlyBuild) {
                itemStack = itemStack.cloneItemStack();
            }
            if (itemStack.a((EntityLiving)entity)) {
                if (itemStack.count <= 0 && !this.abilities.canInstantlyBuild) {
                    this.bD();
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack bC() {
        return this.inventory.getItemInHand();
    }

    public void bD() {
        this.inventory.setItem(this.inventory.itemInHandIndex, null);
    }

    public double W() {
        return this.height - 0.5f;
    }

    public void i() {
        if (!this.bH || this.bI >= this.k() / 2 || this.bI < 0) {
            this.bI = -1;
            this.bH = true;
        }
    }

    public void attack(Entity entity) {
        if (!entity.an()) {
            return;
        }
        int n = this.inventory.a(entity);
        if (this.hasEffect(MobEffectList.INCREASE_DAMAGE)) {
            n += 3 << this.getEffect(MobEffectList.INCREASE_DAMAGE).getAmplifier();
        }
        if (this.hasEffect(MobEffectList.WEAKNESS)) {
            n -= 2 << this.getEffect(MobEffectList.WEAKNESS).getAmplifier();
        }
        int n2 = 0;
        int n3 = 0;
        if (entity instanceof EntityLiving) {
            n3 = EnchantmentManager.a(this.inventory, (EntityLiving)entity);
            n2 += EnchantmentManager.getKnockbackEnchantmentLevel(this.inventory, (EntityLiving)entity);
        }
        if (this.isSprinting()) {
            ++n2;
        }
        if (n > 0 || n3 > 0) {
            ItemStack itemStack;
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = this.fallDistance > 0.0f && !this.onGround && !this.f_() && !this.H() && !this.hasEffect(MobEffectList.BLINDNESS) && this.vehicle == null && entity instanceof EntityLiving;
            if (bl2) {
                n += this.random.nextInt(n / 2 + 2);
            }
            if (bl = entity.damageEntity(DamageSource.playerAttack(this), n += n3)) {
                if (n2 > 0) {
                    entity.g(-MathHelper.sin(this.yaw * (float)Math.PI / 180.0f) * (float)n2 * 0.5f, 0.1, MathHelper.cos(this.yaw * (float)Math.PI / 180.0f) * (float)n2 * 0.5f);
                    this.motX *= 0.6;
                    this.motZ *= 0.6;
                    this.setSprinting(false);
                }
                if (bl2) {
                    this.b(entity);
                }
                if (n3 > 0) {
                    this.c(entity);
                }
                if (n >= 18) {
                    this.a(AchievementList.E);
                }
                this.j(entity);
            }
            if ((itemStack = this.bC()) != null && entity instanceof EntityLiving) {
                itemStack.a((EntityLiving)entity, this);
                if (itemStack.count <= 0) {
                    this.bD();
                }
            }
            if (entity instanceof EntityLiving) {
                if (entity.isAlive()) {
                    this.a((EntityLiving)entity, true);
                }
                this.a(StatisticList.w, n);
                int n4 = EnchantmentManager.getFireAspectEnchantmentLevel(this.inventory, (EntityLiving)entity);
                if (n4 > 0) {
                    entity.setOnFire(n4 * 4);
                }
            }
            this.j(0.3f);
        }
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    public void die() {
        super.die();
        this.defaultContainer.a(this);
        if (this.activeContainer != null) {
            this.activeContainer.a(this);
        }
    }

    public boolean inBlock() {
        return !this.sleeping && super.inBlock();
    }

    public boolean bF() {
        return false;
    }

    public EnumBedResult a(int n, int n2, int n3) {
        if (!this.world.isStatic) {
            if (this.isSleeping() || !this.isAlive()) {
                return EnumBedResult.OTHER_PROBLEM;
            }
            if (!this.world.worldProvider.d()) {
                return EnumBedResult.NOT_POSSIBLE_HERE;
            }
            if (this.world.s()) {
                return EnumBedResult.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.locX - (double)n) > 3.0 || Math.abs(this.locY - (double)n2) > 2.0 || Math.abs(this.locZ - (double)n3) > 3.0) {
                return EnumBedResult.TOO_FAR_AWAY;
            }
            double d = 8.0;
            double d2 = 5.0;
            List list = this.world.a(EntityMonster.class, AxisAlignedBB.a().a((double)n - d, (double)n2 - d2, (double)n3 - d, (double)n + d, (double)n2 + d2, (double)n3 + d));
            if (!list.isEmpty()) {
                return EnumBedResult.NOT_SAFE;
            }
        }
        this.a(0.2f, 0.2f);
        this.height = 0.2f;
        if (this.world.isLoaded(n, n2, n3)) {
            int n4 = this.world.getData(n, n2, n3);
            int n5 = BlockBed.d(n4);
            float f = 0.5f;
            float f2 = 0.5f;
            switch (n5) {
                case 0: {
                    f2 = 0.9f;
                    break;
                }
                case 2: {
                    f2 = 0.1f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            this.b(n5);
            this.setPosition((float)n + f, (float)n2 + 0.9375f, (float)n3 + f2);
        } else {
            this.setPosition((float)n + 0.5f, (float)n2 + 0.9375f, (float)n3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTicks = 0;
        this.bT = new ChunkCoordinates(n, n2, n3);
        this.motY = 0.0;
        this.motZ = 0.0;
        this.motX = 0.0;
        if (!this.world.isStatic) {
            this.world.everyoneSleeping();
        }
        return EnumBedResult.OK;
    }

    private void b(int n) {
        this.bU = 0.0f;
        this.bV = 0.0f;
        switch (n) {
            case 0: {
                this.bV = -1.8f;
                break;
            }
            case 2: {
                this.bV = 1.8f;
                break;
            }
            case 1: {
                this.bU = 1.8f;
                break;
            }
            case 3: {
                this.bU = -1.8f;
            }
        }
    }

    public void a(boolean bl, boolean bl2, boolean bl3) {
        this.a(0.6f, 1.8f);
        this.d_();
        ChunkCoordinates chunkCoordinates = this.bT;
        ChunkCoordinates chunkCoordinates2 = this.bT;
        if (chunkCoordinates != null && this.world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) == Block.BED.id) {
            BlockBed.a(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, false);
            chunkCoordinates2 = BlockBed.b(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
            if (chunkCoordinates2 == null) {
                chunkCoordinates2 = new ChunkCoordinates(chunkCoordinates.x, chunkCoordinates.y + 1, chunkCoordinates.z);
            }
            this.setPosition((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + this.height + 0.1f, (float)chunkCoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isStatic && bl2) {
            this.world.everyoneSleeping();
        }
        this.sleepTicks = bl ? 0 : 100;
        if (bl3) {
            this.setRespawnPosition(this.bT);
        }
    }

    private boolean l() {
        return this.world.getTypeId(this.bT.x, this.bT.y, this.bT.z) == Block.BED.id;
    }

    public static ChunkCoordinates getBed(World world, ChunkCoordinates chunkCoordinates) {
        IChunkProvider iChunkProvider = world.F();
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z + 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z + 3 >> 4);
        if (world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) != Block.BED.id) {
            return null;
        }
        ChunkCoordinates chunkCoordinates2 = BlockBed.b(world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
        return chunkCoordinates2;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public boolean isDeeplySleeping() {
        return this.sleeping && this.sleepTicks >= 100;
    }

    public void c(String string) {
    }

    public ChunkCoordinates getBed() {
        return this.c;
    }

    public void setRespawnPosition(ChunkCoordinates chunkCoordinates) {
        this.c = chunkCoordinates != null ? new ChunkCoordinates(chunkCoordinates) : null;
    }

    public void a(Statistic statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic statistic, int n) {
    }

    protected void aZ() {
        super.aZ();
        this.a(StatisticList.u, 1);
        if (this.isSprinting()) {
            this.j(0.8f);
        } else {
            this.j(0.2f);
        }
    }

    public void e(float f, float f2) {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        if (this.abilities.isFlying && this.vehicle == null) {
            double d4 = this.motY;
            float f3 = this.aH;
            this.aH = this.abilities.a();
            super.e(f, f2);
            this.motY = d4 * 0.6;
            this.aH = f3;
        } else {
            super.e(f, f2);
        }
        this.checkMovement(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    public void checkMovement(double d, double d2, double d3) {
        if (this.vehicle != null) {
            return;
        }
        if (this.a(Material.WATER)) {
            int n = Math.round(MathHelper.sqrt(d * d + d2 * d2 + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.q, n);
                this.j(0.015f * (float)n * 0.01f);
            }
        } else if (this.H()) {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.m, n);
                this.j(0.015f * (float)n * 0.01f);
            }
        } else if (this.f_()) {
            if (d2 > 0.0) {
                this.a(StatisticList.o, (int)Math.round(d2 * 100.0));
            }
        } else if (this.onGround) {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.l, n);
                if (this.isSprinting()) {
                    this.j(0.099999994f * (float)n * 0.01f);
                } else {
                    this.j(0.01f * (float)n * 0.01f);
                }
            }
        } else {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 25) {
                this.a(StatisticList.p, n);
            }
        }
    }

    private void k(double d, double d2, double d3) {
        int n;
        if (this.vehicle != null && (n = Math.round(MathHelper.sqrt(d * d + d2 * d2 + d3 * d3) * 100.0f)) > 0) {
            if (this.vehicle instanceof EntityMinecart) {
                this.a(StatisticList.r, n);
                if (this.d == null) {
                    this.d = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
                } else if ((double)this.d.e(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) >= 1000000.0) {
                    this.a(AchievementList.q, 1);
                }
            } else if (this.vehicle instanceof EntityBoat) {
                this.a(StatisticList.s, n);
            } else if (this.vehicle instanceof EntityPig) {
                this.a(StatisticList.t, n);
            }
        }
    }

    protected void a(float f) {
        if (this.abilities.canFly) {
            return;
        }
        if (f >= 2.0f) {
            this.a(StatisticList.n, (int)Math.round((double)f * 100.0));
        }
        super.a(f);
    }

    public void a(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityMonster) {
            this.a(AchievementList.s);
        }
    }

    public void aa() {
        if (this.bW > 0) {
            this.bW = 10;
            return;
        }
        this.bX = true;
    }

    public void giveExp(int n) {
        this.bE += n;
        int n2 = Integer.MAX_VALUE - this.expTotal;
        if (n > n2) {
            n = n2;
        }
        this.exp += (float)n / (float)this.getExpToLevel();
        this.expTotal += n;
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.levelUp();
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void levelDown(int n) {
        this.expLevel -= n;
        if (this.expLevel < 0) {
            this.expLevel = 0;
        }
    }

    public int getExpToLevel() {
        if (this.expLevel >= 30) {
            return 62 + (this.expLevel - 30) * 7;
        }
        if (this.expLevel >= 15) {
            return 17 + (this.expLevel - 15) * 3;
        }
        return 17;
    }

    private void levelUp() {
        ++this.expLevel;
    }

    public void j(float f) {
        if (this.abilities.isInvulnerable) {
            return;
        }
        if (!this.world.isStatic) {
            this.foodData.a(f);
        }
    }

    public FoodMetaData getFoodData() {
        return this.foodData;
    }

    public boolean e(boolean bl) {
        return (bl || this.foodData.c()) && !this.abilities.isInvulnerable;
    }

    public boolean bM() {
        return this.getHealth() > 0 && this.getHealth() < this.getMaxHealth();
    }

    public void a(ItemStack itemStack, int n) {
        if (itemStack == this.e) {
            return;
        }
        this.e = itemStack;
        this.f = n;
        if (!this.world.isStatic) {
            this.c(true);
        }
    }

    public boolean e(int n, int n2, int n3) {
        return this.abilities.mayBuild;
    }

    protected int getExpValue(EntityHuman entityHuman) {
        int n = this.expLevel * 7;
        if (n > 100) {
            return 100;
        }
        return n;
    }

    protected boolean alwaysGivesExp() {
        return true;
    }

    public String getLocalizedName() {
        return this.name;
    }

    public void c(int n) {
    }

    public void copyTo(EntityHuman entityHuman, boolean bl) {
        if (bl) {
            this.inventory.b(entityHuman.inventory);
            this.health = entityHuman.health;
            this.foodData = entityHuman.foodData;
            this.expLevel = entityHuman.expLevel;
            this.expTotal = entityHuman.expTotal;
            this.exp = entityHuman.exp;
            this.bE = entityHuman.bE;
        }
        this.enderChest = entityHuman.enderChest;
    }

    protected boolean e_() {
        return !this.abilities.isFlying;
    }

    public void updateAbilities() {
    }

    public void a(EnumGamemode enumGamemode) {
    }

    public String getName() {
        return this.name;
    }

    public LocaleLanguage getLocale() {
        return LocaleLanguage.a();
    }

    public String a(String string, Object ... objectArray) {
        return this.getLocale().a(string, objectArray);
    }

    public InventoryEnderChest getEnderChest() {
        return this.enderChest;
    }
}

