/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.FileIOThread;
import net.minecraft.server.IAsyncChunkSaver;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.NBTCompressedStreamTools;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.NibbleArray;
import net.minecraft.server.PendingChunkToSave;
import net.minecraft.server.RegionFileCache;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class ChunkRegionLoader
implements IAsyncChunkSaver,
IChunkLoader {
    private List a = new ArrayList();
    private Set b = new HashSet();
    private Object c = new Object();
    private final File d;

    public ChunkRegionLoader(File file) {
        this.d = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk a(World world, int n, int n2) {
        NBTTagCompound nBTTagCompound = null;
        ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(n, n2);
        Object object = this.c;
        synchronized (object) {
            if (this.b.contains(chunkCoordIntPair)) {
                for (PendingChunkToSave pendingChunkToSave : this.a) {
                    if (!pendingChunkToSave.a.equals(chunkCoordIntPair)) continue;
                    nBTTagCompound = pendingChunkToSave.b;
                    break;
                }
            }
        }
        if (nBTTagCompound == null) {
            object = RegionFileCache.c(this.d, n, n2);
            if (object != null) {
                nBTTagCompound = NBTCompressedStreamTools.a((DataInput)object);
            } else {
                return null;
            }
        }
        return this.a(world, n, n2, nBTTagCompound);
    }

    protected Chunk a(World world, int n, int n2, NBTTagCompound nBTTagCompound) {
        if (!nBTTagCompound.hasKey("Level")) {
            System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
            return null;
        }
        if (!nBTTagCompound.getCompound("Level").hasKey("Sections")) {
            System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
            return null;
        }
        Chunk chunk = this.a(world, nBTTagCompound.getCompound("Level"));
        if (!chunk.a(n, n2)) {
            System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + chunk.x + ", " + chunk.z + ")");
            nBTTagCompound.setInt("xPos", n);
            nBTTagCompound.setInt("zPos", n2);
            chunk = this.a(world, nBTTagCompound.getCompound("Level"));
        }
        return chunk;
    }

    public void a(World world, Chunk chunk) {
        world.B();
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.set("Level", nBTTagCompound2);
            this.a(chunk, world, nBTTagCompound2);
            this.a(chunk.l(), nBTTagCompound);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChunkCoordIntPair chunkCoordIntPair, NBTTagCompound nBTTagCompound) {
        Object object = this.c;
        synchronized (object) {
            if (this.b.contains(chunkCoordIntPair)) {
                for (int i = 0; i < this.a.size(); ++i) {
                    if (!((PendingChunkToSave)this.a.get((int)i)).a.equals(chunkCoordIntPair)) continue;
                    this.a.set(i, new PendingChunkToSave(chunkCoordIntPair, nBTTagCompound));
                    return;
                }
            }
            this.a.add(new PendingChunkToSave(chunkCoordIntPair, nBTTagCompound));
            this.b.add(chunkCoordIntPair);
            FileIOThread.a.a(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean c() {
        PendingChunkToSave pendingChunkToSave = null;
        Object object = this.c;
        synchronized (object) {
            if (this.a.isEmpty()) {
                return false;
            }
            pendingChunkToSave = (PendingChunkToSave)this.a.remove(0);
            this.b.remove(pendingChunkToSave.a);
        }
        if (pendingChunkToSave != null) {
            try {
                this.a(pendingChunkToSave);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    private void a(PendingChunkToSave pendingChunkToSave) {
        DataOutputStream dataOutputStream = RegionFileCache.d(this.d, pendingChunkToSave.a.x, pendingChunkToSave.a.z);
        NBTCompressedStreamTools.a(pendingChunkToSave.b, dataOutputStream);
        dataOutputStream.close();
    }

    public void b(World world, Chunk chunk) {
    }

    public void a() {
    }

    public void b() {
    }

    private void a(Chunk chunk, World world, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        nBTTagCompound.setInt("xPos", chunk.x);
        nBTTagCompound.setInt("zPos", chunk.z);
        nBTTagCompound.setLong("LastUpdate", world.getTime());
        nBTTagCompound.setIntArray("HeightMap", chunk.heightMap);
        nBTTagCompound.setBoolean("TerrainPopulated", chunk.done);
        ChunkSection[] chunkSectionArray = chunk.i();
        NBTTagList nBTTagList = new NBTTagList("Sections");
        for (ChunkSection object : chunkSectionArray) {
            if (object == null) continue;
            nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.setByte("Y", (byte)(object.d() >> 4 & 0xFF));
            nBTTagCompound2.setByteArray("Blocks", object.g());
            if (object.i() != null) {
                nBTTagCompound2.setByteArray("Add", object.i().a);
            }
            nBTTagCompound2.setByteArray("Data", object.j().a);
            nBTTagCompound2.setByteArray("SkyLight", object.l().a);
            nBTTagCompound2.setByteArray("BlockLight", object.k().a);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Sections", nBTTagList);
        nBTTagCompound.setByteArray("Biomes", chunk.m());
        chunk.m = false;
        NBTTagList nBTTagList2 = new NBTTagList();
        for (int i = 0; i < chunk.entitySlices.length; ++i) {
            for (Entity entity : chunk.entitySlices[i]) {
                chunk.m = true;
                nBTTagCompound2 = new NBTTagCompound();
                if (!entity.c(nBTTagCompound2)) continue;
                nBTTagList2.add(nBTTagCompound2);
            }
        }
        nBTTagCompound.set("Entities", nBTTagList2);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (TileEntity tileEntity : chunk.tileEntities.values()) {
            nBTTagCompound2 = new NBTTagCompound();
            tileEntity.b(nBTTagCompound2);
            nBTTagList3.add(nBTTagCompound2);
        }
        nBTTagCompound.set("TileEntities", nBTTagList3);
        List list = world.a(chunk, false);
        if (list != null) {
            long l = world.getTime();
            NBTTagList nBTTagList4 = new NBTTagList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                nBTTagCompound3.setInt("i", nextTickListEntry.d);
                nBTTagCompound3.setInt("x", nextTickListEntry.a);
                nBTTagCompound3.setInt("y", nextTickListEntry.b);
                nBTTagCompound3.setInt("z", nextTickListEntry.c);
                nBTTagCompound3.setInt("t", (int)(nextTickListEntry.e - l));
                nBTTagList4.add(nBTTagCompound3);
            }
            nBTTagCompound.set("TileTicks", nBTTagList4);
        }
    }

    private Chunk a(World world, NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        Object object;
        NBTTagList nBTTagList2;
        NBTTagList nBTTagList3;
        Object object2;
        int n = nBTTagCompound.getInt("xPos");
        int n2 = nBTTagCompound.getInt("zPos");
        Chunk chunk = new Chunk(world, n, n2);
        chunk.heightMap = nBTTagCompound.getIntArray("HeightMap");
        chunk.done = nBTTagCompound.getBoolean("TerrainPopulated");
        NBTTagList nBTTagList4 = nBTTagCompound.getList("Sections");
        int n3 = 16;
        ChunkSection[] chunkSectionArray = new ChunkSection[n3];
        for (int i = 0; i < nBTTagList4.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList4.get(i);
            byte by = nBTTagCompound2.getByte("Y");
            object2 = new ChunkSection(by << 4);
            ((ChunkSection)object2).a(nBTTagCompound2.getByteArray("Blocks"));
            if (nBTTagCompound2.hasKey("Add")) {
                ((ChunkSection)object2).a(new NibbleArray(nBTTagCompound2.getByteArray("Add"), 4));
            }
            ((ChunkSection)object2).b(new NibbleArray(nBTTagCompound2.getByteArray("Data"), 4));
            ((ChunkSection)object2).d(new NibbleArray(nBTTagCompound2.getByteArray("SkyLight"), 4));
            ((ChunkSection)object2).c(new NibbleArray(nBTTagCompound2.getByteArray("BlockLight"), 4));
            ((ChunkSection)object2).e();
            chunkSectionArray[by] = object2;
        }
        chunk.a(chunkSectionArray);
        if (nBTTagCompound.hasKey("Biomes")) {
            chunk.a(nBTTagCompound.getByteArray("Biomes"));
        }
        if ((nBTTagList3 = nBTTagCompound.getList("Entities")) != null) {
            for (int i = 0; i < nBTTagList3.size(); ++i) {
                NBTTagCompound nBTTagCompound3 = (NBTTagCompound)nBTTagList3.get(i);
                object2 = EntityTypes.a(nBTTagCompound3, world);
                chunk.m = true;
                if (object2 == null) continue;
                chunk.a((Entity)object2);
            }
        }
        if ((nBTTagList2 = nBTTagCompound.getList("TileEntities")) != null) {
            for (int i = 0; i < nBTTagList2.size(); ++i) {
                object2 = (NBTTagCompound)nBTTagList2.get(i);
                object = TileEntity.c((NBTTagCompound)object2);
                if (object == null) continue;
                chunk.a((TileEntity)object);
            }
        }
        if (nBTTagCompound.hasKey("TileTicks") && (nBTTagList = nBTTagCompound.getList("TileTicks")) != null) {
            for (int i = 0; i < nBTTagList.size(); ++i) {
                object = (NBTTagCompound)nBTTagList.get(i);
                world.b(((NBTTagCompound)object).getInt("x"), ((NBTTagCompound)object).getInt("y"), ((NBTTagCompound)object).getInt("z"), ((NBTTagCompound)object).getInt("i"), ((NBTTagCompound)object).getInt("t"));
            }
        }
        return chunk;
    }
}

