/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import net.md_5.bungee.api.Callback;

public class HttpHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final Callback<String> callback;
    private final StringBuilder buffer = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            this.callback.done(null, cause);
        }
        finally {
            ctx.channel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        HttpResponse response;
        if (msg instanceof HttpResponse && (response = (HttpResponse)msg).getStatus().code() != 200) {
            throw new IllegalStateException("Expected HTTP response 200 OK, got " + response.getStatus());
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.buffer.append(content.content().toString(Charset.forName("UTF-8")));
            if (msg instanceof LastHttpContent) {
                try {
                    this.callback.done(this.buffer.toString(), null);
                }
                finally {
                    ctx.channel().close();
                }
            }
        }
    }

    @ConstructorProperties(value={"callback"})
    public HttpHandler(Callback<String> callback) {
        this.callback = callback;
    }
}

