/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

class YamlConfiguration
extends ConfigurationProvider {
    private final ThreadLocal<Yaml> yaml = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return new Yaml(options);
        }
    };

    YamlConfiguration() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Configuration load(File file) {
        try (FileReader reader = new FileReader(file);){
            Configuration configuration = this.load(reader);
            return configuration;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Configuration load(Reader reader) {
        Configuration conf = new Configuration(this.yaml.get().loadAs(reader, Map.class), null);
        return conf;
    }

    @Override
    public Configuration load(String string) {
        Configuration conf = new Configuration(this.yaml.get().loadAs(string, Map.class), null);
        return conf;
    }
}

