/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.skip;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.md_5.bungee.protocol.OpCode;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.skip.Instruction;
import net.md_5.bungee.protocol.skip.Jump;

public class PacketReader {
    private final Instruction[][] instructions;

    public PacketReader(Protocol protocol) {
        this.instructions = new Instruction[protocol.getOpCodes().length][];
        for (int i = 0; i < this.instructions.length; ++i) {
            ArrayList<Instruction> output = new ArrayList<Instruction>();
            OpCode[] enums = protocol.getOpCodes()[i];
            if (enums == null) continue;
            for (OpCode struct : enums) {
                try {
                    output.add((Instruction)Instruction.class.getDeclaredField(struct.name()).get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    throw new UnsupportedOperationException("No definition for " + struct.name());
                }
            }
            ArrayList<Instruction> crushed = new ArrayList<Instruction>();
            int nextJumpSize = 0;
            for (Instruction child : output) {
                if (child instanceof Jump) {
                    nextJumpSize += ((Jump)child).len;
                    continue;
                }
                if (nextJumpSize != 0) {
                    crushed.add(new Jump(nextJumpSize));
                }
                crushed.add(child);
                nextJumpSize = 0;
            }
            if (nextJumpSize != 0) {
                crushed.add(new Jump(nextJumpSize));
            }
            this.instructions[i] = crushed.toArray(new Instruction[crushed.size()]);
        }
    }

    public void tryRead(short packetId, ByteBuf in) {
        Instruction[] packetDef = this.instructions[packetId];
        if (packetDef != null) {
            for (Instruction instruction : packetDef) {
                instruction.read(in);
            }
        }
    }
}

