/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

public class EntityMap {
    public static final int[][] entityIds = new int[256][];

    public static void rewrite(byte[] packet, int oldId, int newId) {
        int type;
        int packetId = packet[0] & 0xFF;
        if (packetId == 29) {
            for (int pos = 2; pos < packet.length; pos += 4) {
                int readId = EntityMap.readInt(packet, pos);
                if (readId == oldId) {
                    EntityMap.setInt(packet, pos, newId);
                    continue;
                }
                if (readId != newId) continue;
                EntityMap.setInt(packet, pos, oldId);
            }
        } else {
            int[] idArray = entityIds[packetId];
            if (idArray != null) {
                for (int pos : idArray) {
                    int readId = EntityMap.readInt(packet, pos);
                    if (readId == oldId) {
                        EntityMap.setInt(packet, pos, newId);
                        continue;
                    }
                    if (readId != newId) continue;
                    EntityMap.setInt(packet, pos, oldId);
                }
            }
        }
        if (packetId == 23 && ((type = packet[5] & 0xFF) == 60 || type == 90)) {
            int index20 = EntityMap.readInt(packet, 20);
            if (packet.length > 24 && index20 == oldId) {
                EntityMap.setInt(packet, 20, newId);
            }
        }
    }

    private static void setInt(byte[] buf, int pos, int i) {
        buf[pos] = (byte)(i >> 24);
        buf[pos + 1] = (byte)(i >> 16);
        buf[pos + 2] = (byte)(i >> 8);
        buf[pos + 3] = (byte)i;
    }

    private static int readInt(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) << 24 | (buf[pos + 1] & 0xFF) << 16 | (buf[pos + 2] & 0xFF) << 8 | buf[pos + 3] & 0xFF;
    }

    static {
        EntityMap.entityIds[5] = new int[]{1};
        EntityMap.entityIds[7] = new int[]{1, 5};
        EntityMap.entityIds[17] = new int[]{1};
        EntityMap.entityIds[18] = new int[]{1};
        EntityMap.entityIds[19] = new int[]{1};
        EntityMap.entityIds[20] = new int[]{1};
        EntityMap.entityIds[22] = new int[]{1, 5};
        EntityMap.entityIds[23] = new int[]{1};
        EntityMap.entityIds[24] = new int[]{1};
        EntityMap.entityIds[25] = new int[]{1};
        EntityMap.entityIds[26] = new int[]{1};
        EntityMap.entityIds[28] = new int[]{1};
        EntityMap.entityIds[30] = new int[]{1};
        EntityMap.entityIds[31] = new int[]{1};
        EntityMap.entityIds[32] = new int[]{1};
        EntityMap.entityIds[33] = new int[]{1};
        EntityMap.entityIds[34] = new int[]{1};
        EntityMap.entityIds[35] = new int[]{1};
        EntityMap.entityIds[38] = new int[]{1};
        EntityMap.entityIds[39] = new int[]{1, 5};
        EntityMap.entityIds[40] = new int[]{1};
        EntityMap.entityIds[41] = new int[]{1};
        EntityMap.entityIds[42] = new int[]{1};
        EntityMap.entityIds[44] = new int[]{1};
        EntityMap.entityIds[55] = new int[]{1};
        EntityMap.entityIds[71] = new int[]{1};
    }
}

