/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;

public abstract class DefinedPacket {
    private final int id;

    public final int getId() {
        return this.id;
    }

    public void writeString(String s, ByteBuf buf) {
        buf.writeShort(s.length());
        for (char c : s.toCharArray()) {
            buf.writeChar(c);
        }
    }

    public String readString(ByteBuf buf) {
        int len = buf.readShort();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = buf.readChar();
        }
        return new String(chars);
    }

    public void writeArray(byte[] b, ByteBuf buf) {
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    public byte[] readArray(ByteBuf buf) {
        short len = buf.readShort();
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public abstract void read(ByteBuf var1);

    public abstract void write(ByteBuf var1);

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @ConstructorProperties(value={"id"})
    public DefinedPacket(int id) {
        this.id = id;
    }
}

