/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;

public class ChannelWrapper {
    private final Channel ch;
    private volatile boolean closed;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
    }

    public synchronized void write(Object packet) {
        if (!this.closed) {
            this.ch.write(packet);
            this.ch.flush();
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.ch.flush();
            this.ch.close();
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

