/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.tokens;

import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;

public abstract class Token {
    private final Mark startMark;
    private final Mark endMark;

    public Token(Mark startMark, Mark endMark) {
        if (startMark == null || endMark == null) {
            throw new YAMLException("Token requires marks.");
        }
        this.startMark = startMark;
        this.endMark = endMark;
    }

    public String toString() {
        return "<" + this.getClass().getName() + "(" + this.getArguments() + ")>";
    }

    public Mark getStartMark() {
        return this.startMark;
    }

    public Mark getEndMark() {
        return this.endMark;
    }

    protected String getArguments() {
        return "";
    }

    public abstract ID getTokenId();

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ID
    extends Enum<ID> {
        public static final /* enum */ ID Alias = new ID();
        public static final /* enum */ ID Anchor = new ID();
        public static final /* enum */ ID BlockEnd = new ID();
        public static final /* enum */ ID BlockEntry = new ID();
        public static final /* enum */ ID BlockMappingStart = new ID();
        public static final /* enum */ ID BlockSequenceStart = new ID();
        public static final /* enum */ ID Directive = new ID();
        public static final /* enum */ ID DocumentEnd = new ID();
        public static final /* enum */ ID DocumentStart = new ID();
        public static final /* enum */ ID FlowEntry = new ID();
        public static final /* enum */ ID FlowMappingEnd = new ID();
        public static final /* enum */ ID FlowMappingStart = new ID();
        public static final /* enum */ ID FlowSequenceEnd = new ID();
        public static final /* enum */ ID FlowSequenceStart = new ID();
        public static final /* enum */ ID Key = new ID();
        public static final /* enum */ ID Scalar = new ID();
        public static final /* enum */ ID StreamEnd = new ID();
        public static final /* enum */ ID StreamStart = new ID();
        public static final /* enum */ ID Tag = new ID();
        public static final /* enum */ ID Value = new ID();
        private static final /* synthetic */ ID[] $VALUES;

        static {
            $VALUES = new ID[]{Alias, Anchor, BlockEnd, BlockEntry, BlockMappingStart, BlockSequenceStart, Directive, DocumentEnd, DocumentStart, FlowEntry, FlowMappingEnd, FlowMappingStart, FlowSequenceEnd, FlowSequenceStart, Key, Scalar, StreamEnd, StreamStart, Tag, Value};
        }
    }
}

