/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Queue;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.PacketConstants;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.api.score.Team;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.CipherDecoder;
import net.md_5.bungee.netty.CipherEncoder;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketDecoder;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.Forge;
import net.md_5.bungee.protocol.MinecraftOutput;
import net.md_5.bungee.protocol.packet.DefinedPacket;
import net.md_5.bungee.protocol.packet.Packet1Login;
import net.md_5.bungee.protocol.packet.Packet9Respawn;
import net.md_5.bungee.protocol.packet.PacketCEScoreboardObjective;
import net.md_5.bungee.protocol.packet.PacketD1Team;
import net.md_5.bungee.protocol.packet.PacketFAPluginMessage;
import net.md_5.bungee.protocol.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.protocol.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.protocol.packet.PacketFFKick;
import net.md_5.bungee.protocol.packet.forge.Forge1Login;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.ENCRYPT_REQUEST;
    private SecretKey secretkey;
    private boolean sentMessages;

    @Override
    public void exception(Throwable t) throws Exception {
        String message = "Exception Connecting:" + Util.exception(t);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage((Object)((Object)ChatColor.RED) + message);
        }
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Login");
        out.writeUTF(this.user.getAddress().getHostString());
        out.writeInt(this.user.getAddress().getPort());
        channel.write(new PacketFAPluginMessage("BungeeCord", out.toByteArray()));
        channel.write(this.user.getPendingConnection().getHandshake());
        if (this.user.getPendingConnection().getForgeLogin() == null) {
            channel.write(PacketConstants.CLIENT_LOGIN);
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(final Packet1Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not exepcting LOGIN");
        Object object = this.user.getSwitchMutex();
        synchronized (object) {
            if (this.user.getServer() != null) {
                this.user.sendDimensionSwitch();
                this.user.getServer().setObsolete(true);
                this.user.getServer().disconnect("Quitting");
            }
        }
        final ServerConnection server = new ServerConnection(this.ch, this.target);
        Callback<ServerConnectedEvent> callback = new Callback<ServerConnectedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(ServerConnectedEvent result, Throwable error) {
                ServerConnector.this.ch.write(BungeeCord.getInstance().registerChannels());
                Queue<DefinedPacket> packetQueue = ServerConnector.this.target.getPacketQueue();
                Object object = packetQueue;
                synchronized (object) {
                    while (!packetQueue.isEmpty()) {
                        ServerConnector.this.ch.write(packetQueue.poll());
                    }
                }
                for (PacketFAPluginMessage message : ServerConnector.this.user.getPendingConnection().getRegisterMessages()) {
                    ServerConnector.this.ch.write(message);
                }
                if (!ServerConnector.this.sentMessages) {
                    for (PacketFAPluginMessage message : ServerConnector.this.user.getPendingConnection().getLoginMessages()) {
                        ServerConnector.this.ch.write(message);
                    }
                }
                if (ServerConnector.this.user.getSettings() != null) {
                    ServerConnector.this.ch.write(ServerConnector.this.user.getSettings());
                }
                object = ServerConnector.this.user.getSwitchMutex();
                synchronized (object) {
                    if (ServerConnector.this.user.getServer() == null) {
                        ServerConnector.this.user.setClientEntityId(login.getEntityId());
                        ServerConnector.this.user.setServerEntityId(login.getEntityId());
                        Packet1Login modLogin = ServerConnector.this.ch.getHandle().pipeline().get(PacketDecoder.class).getProtocol() == Forge.getInstance() ? new Forge1Login(login.getEntityId(), login.getLevelType(), login.getGameMode(), login.getDimension(), login.getDifficulty(), login.getUnused(), (byte)ServerConnector.this.user.getPendingConnection().getListener().getTabListSize()) : new Packet1Login(login.getEntityId(), login.getLevelType(), login.getGameMode(), (byte)login.getDimension(), login.getDifficulty(), login.getUnused(), (byte)ServerConnector.this.user.getPendingConnection().getListener().getTabListSize());
                        ServerConnector.this.user.unsafe().sendPacket(modLogin);
                        MinecraftOutput out = new MinecraftOutput();
                        out.writeStringUTF8WithoutLengthHeaderBecauseDinnerboneStuffedUpTheMCBrandPacket(ProxyServer.getInstance().getName() + " (" + ProxyServer.getInstance().getVersion() + ")");
                        ServerConnector.this.user.unsafe().sendPacket(new PacketFAPluginMessage("MC|Brand", out.toArray()));
                    } else {
                        ServerConnector.this.user.getTabList().onServerChange();
                        Scoreboard serverScoreboard = ServerConnector.this.user.getServerSentScoreboard();
                        for (Objective objective : serverScoreboard.getObjectives()) {
                            ServerConnector.this.user.unsafe().sendPacket(new PacketCEScoreboardObjective(objective.getName(), objective.getValue(), 1));
                        }
                        for (Team team : serverScoreboard.getTeams()) {
                            ServerConnector.this.user.unsafe().sendPacket(new PacketD1Team(team.getName()));
                        }
                        serverScoreboard.clear();
                        ServerConnector.this.user.setServerEntityId(login.getEntityId());
                        ServerConnector.this.user.unsafe().sendPacket(new Packet9Respawn(login.getDimension(), login.getDifficulty(), login.getGameMode(), 256, login.getLevelType()));
                    }
                    if (!ServerConnector.this.user.isActive()) {
                        server.disconnect("Quitting");
                        ServerConnector.this.bungee.getLogger().warning("No client connected for pending server!");
                        return;
                    }
                    ServerConnector.this.target.addPlayer(ServerConnector.this.user);
                    ServerConnector.this.user.getPendingConnects().remove(ServerConnector.this.target);
                    ServerConnector.this.user.setServer(server);
                    ServerConnector.this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(ServerConnector.this.bungee, ServerConnector.this.user, server));
                }
                ServerConnector.this.bungee.getPluginManager().callEvent(new ServerSwitchEvent(ServerConnector.this.user));
                ServerConnector.this.thisState = State.FINISHED;
            }
        };
        ServerConnectedEvent event = new ServerConnectedEvent(this.user, server, callback);
        this.bungee.getPluginManager().callEvent(event);
        throw new CancelSendSignal();
    }

    @Override
    public void handle(PacketFDEncryptionRequest encryptRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT_REQUEST, "Not expecting ENCRYPT_REQUEST");
        if (this.user.getPendingConnection().getForgeLogin() != null) {
            PublicKey publickey = EncryptionUtil.getPubkey(encryptRequest);
            this.secretkey = EncryptionUtil.getSecret();
            byte[] shared = EncryptionUtil.encrypt(publickey, this.secretkey.getEncoded());
            byte[] token = EncryptionUtil.encrypt(publickey, encryptRequest.getVerifyToken());
            this.ch.write(new PacketFCEncryptionResponse(shared, token));
            Cipher encrypt = EncryptionUtil.getCipher(1, this.secretkey);
            this.ch.addBefore(PipelineUtils.PACKET_DECODE_HANDLER, PipelineUtils.ENCRYPT_HANDLER, new CipherEncoder(encrypt));
            this.thisState = State.ENCRYPT_RESPONSE;
        } else {
            this.thisState = State.LOGIN;
        }
    }

    @Override
    public void handle(PacketFCEncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT_RESPONSE, "Not expecting ENCRYPT_RESPONSE");
        Cipher decrypt = EncryptionUtil.getCipher(2, this.secretkey);
        this.ch.addBefore(PipelineUtils.PACKET_DECODE_HANDLER, PipelineUtils.DECRYPT_HANDLER, new CipherDecoder(decrypt));
        this.ch.write(this.user.getPendingConnection().getForgeLogin());
        this.ch.write(PacketConstants.CLIENT_LOGIN);
        this.thisState = State.LOGIN;
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.user.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.target, def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.user, kick.getMessage(), def, ServerKickEvent.State.CONNECTING))).isCancelled() && event.getCancelServer() != null) {
            this.user.connect(event.getCancelServer());
            return;
        }
        String message = this.bungee.getTranslation("connect_kick") + this.target.getName() + ": " + kick.getMessage();
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        if (pluginMessage.equals(PacketConstants.I_AM_BUNGEE)) {
            throw new IllegalStateException("May not connect to another BungeCord!");
        }
        DataInput in = pluginMessage.getStream();
        if (pluginMessage.getTag().equals("FML") && in.readUnsignedByte() == 0) {
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                in.readUTF();
            }
            if (in.readByte() != 0) {
                this.ch.getHandle().pipeline().get(PacketDecoder.class).setProtocol(Forge.getInstance());
            }
        }
        this.user.unsafe().sendPacket(pluginMessage);
        if (!this.sentMessages && this.user.getPendingConnection().getForgeLogin() != null) {
            for (PacketFAPluginMessage message : this.user.getPendingConnection().getLoginMessages()) {
                this.ch.write(message);
            }
            this.sentMessages = true;
        }
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "user", "target"})
    public ServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    private static enum State {
        ENCRYPT_REQUEST,
        ENCRYPT_RESPONSE,
        LOGIN,
        FINISHED;

    }
}

