/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Map;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<HttpObject> {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ZERO_CRLF = new byte[]{48, 13, 10};
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final byte[] HEADER_SEPARATOR = new byte[]{58, 32};
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private int state = 0;

    @Override
    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg instanceof HttpMessage) {
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + msg.getClass().getSimpleName());
            }
            HttpMessage m = (HttpMessage)msg;
            ByteBuf buf = ctx.alloc().buffer();
            this.encodeInitialLine(buf, m);
            HttpObjectEncoder.encodeHeaders(buf, m.headers());
            buf.writeBytes(CRLF);
            out.add(buf);
            int n = this.state = HttpHeaders.isTransferEncodingChunked(m) ? 2 : 1;
        }
        if (msg instanceof HttpContent) {
            if (this.state == 0) {
                throw new IllegalStateException("unexpected message type: " + msg.getClass().getSimpleName());
            }
            HttpContent chunk = (HttpContent)msg;
            ByteBuf content = chunk.content();
            int contentLength = content.readableBytes();
            if (this.state == 1) {
                if (contentLength > 0) {
                    out.add(content.retain());
                } else {
                    out.add(Unpooled.EMPTY_BUFFER);
                }
                if (chunk instanceof LastHttpContent) {
                    this.state = 0;
                }
            } else if (this.state == 2) {
                ByteBuf buf;
                if (contentLength > 0) {
                    byte[] length = Integer.toHexString(contentLength).getBytes(CharsetUtil.US_ASCII);
                    buf = ctx.alloc().buffer(length.length + 2);
                    buf.writeBytes(length);
                    buf.writeBytes(CRLF);
                    out.add(buf);
                    out.add(content.retain());
                    out.add(ctx.alloc().buffer(CRLF.length).writeBytes(CRLF));
                }
                if (chunk instanceof LastHttpContent) {
                    HttpHeaders headers = ((LastHttpContent)chunk).trailingHeaders();
                    if (headers.isEmpty()) {
                        out.add(ctx.alloc().buffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF));
                    } else {
                        buf = ctx.alloc().buffer();
                        buf.writeBytes(ZERO_CRLF);
                        HttpObjectEncoder.encodeHeaders(buf, headers);
                        buf.writeBytes(CRLF);
                        out.add(buf);
                    }
                    this.state = 0;
                } else if (contentLength == 0) {
                    out.add(Unpooled.EMPTY_BUFFER);
                }
            } else {
                throw new Error();
            }
        }
    }

    private static void encodeHeaders(ByteBuf buf, HttpHeaders headers) {
        for (Map.Entry h : headers) {
            HttpObjectEncoder.encodeHeader(buf, (String)h.getKey(), (String)h.getValue());
        }
    }

    private static void encodeHeader(ByteBuf buf, String header, String value) {
        HttpObjectEncoder.encodeAscii(header, buf);
        buf.writeBytes(HEADER_SEPARATOR);
        HttpObjectEncoder.encodeAscii(value, buf);
        buf.writeBytes(CRLF);
    }

    protected static void encodeAscii(String s, ByteBuf buf) {
        for (int i = 0; i < s.length(); ++i) {
            buf.writeByte(s.charAt(i));
        }
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

