/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class Packet1Login
extends DefinedPacket {
    protected int entityId;
    protected String levelType;
    protected byte gameMode;
    protected int dimension;
    protected byte difficulty;
    protected byte unused;
    protected byte maxPlayers;

    protected Packet1Login() {
        super(1);
    }

    public Packet1Login(int entityId, String levelType, byte gameMode, byte dimension, byte difficulty, byte unused, byte maxPlayers) {
        this(entityId, levelType, gameMode, (int)dimension, difficulty, unused, maxPlayers);
    }

    public Packet1Login(int entityId, String levelType, byte gameMode, int dimension, byte difficulty, byte unused, byte maxPlayers) {
        this();
        this.entityId = entityId;
        this.levelType = levelType;
        this.gameMode = gameMode;
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.unused = unused;
        this.maxPlayers = maxPlayers;
    }

    @Override
    public void read(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.levelType = this.readString(buf);
        this.gameMode = buf.readByte();
        this.dimension = buf.readByte();
        this.difficulty = buf.readByte();
        this.unused = buf.readByte();
        this.maxPlayers = buf.readByte();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.entityId);
        this.writeString(this.levelType, buf);
        buf.writeByte(this.gameMode);
        buf.writeByte(this.dimension);
        buf.writeByte(this.difficulty);
        buf.writeByte(this.unused);
        buf.writeByte(this.maxPlayers);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public byte getGameMode() {
        return this.gameMode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public byte getUnused() {
        return this.unused;
    }

    public byte getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    public String toString() {
        return "Packet1Login(entityId=" + this.getEntityId() + ", levelType=" + this.getLevelType() + ", gameMode=" + this.getGameMode() + ", dimension=" + this.getDimension() + ", difficulty=" + this.getDifficulty() + ", unused=" + this.getUnused() + ", maxPlayers=" + this.getMaxPlayers() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet1Login)) {
            return false;
        }
        Packet1Login other = (Packet1Login)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getUnused() != other.getUnused()) {
            return false;
        }
        return this.getMaxPlayers() == other.getMaxPlayers();
    }

    public boolean canEqual(Object other) {
        return other instanceof Packet1Login;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getEntityId();
        String $levelType = this.getLevelType();
        result = result * 31 + ($levelType == null ? 0 : $levelType.hashCode());
        result = result * 31 + this.getGameMode();
        result = result * 31 + this.getDimension();
        result = result * 31 + this.getDifficulty();
        result = result * 31 + this.getUnused();
        result = result * 31 + this.getMaxPlayers();
        return result;
    }
}

