/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class Packet2CEntityProperties
extends DefinedPacket {
    private int entityId;
    private Map<String, Double> data = new HashMap<String, Double>();

    public Packet2CEntityProperties() {
        super(44);
    }

    @Override
    public void read(ByteBuf buf) {
        this.entityId = buf.readInt();
        int recordCount = buf.readInt();
        for (int i = 0; i < recordCount; ++i) {
            this.data.put(this.readString(buf), buf.readDouble());
        }
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.data.size());
        for (Map.Entry<String, Double> entry : this.data.entrySet()) {
            this.writeString(entry.getKey(), buf);
            buf.writeDouble(entry.getValue());
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Map<String, Double> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "Packet2CEntityProperties(entityId=" + this.getEntityId() + ", data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet2CEntityProperties)) {
            return false;
        }
        Packet2CEntityProperties other = (Packet2CEntityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Map<String, Double> this$data = this.getData();
        Map<String, Double> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public boolean canEqual(Object other) {
        return other instanceof Packet2CEntityProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getEntityId();
        Map<String, Double> $data = this.getData();
        result = result * 31 + ($data == null ? 0 : ((Object)$data).hashCode());
        return result;
    }
}

