/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.buffer.BufType;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.embedded.AbstractEmbeddedChannel;
import java.util.Collection;

public class EmbeddedMessageChannel
extends AbstractEmbeddedChannel<Object> {
    private static final ChannelMetadata METADATA = new ChannelMetadata(BufType.MESSAGE, false);

    public EmbeddedMessageChannel(ChannelHandler ... handlers) {
        super(Unpooled.messageBuffer(), handlers);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public MessageBuf<Object> inboundBuffer() {
        return this.pipeline().inboundMessageBuffer();
    }

    @Override
    public MessageBuf<Object> lastOutboundBuffer() {
        return (MessageBuf)this.lastOutboundBuffer;
    }

    @Override
    public Object readOutbound() {
        return this.lastOutboundBuffer().poll();
    }

    @Override
    protected void writeInbound0(Object data) {
        this.inboundBuffer().add(data);
    }

    @Override
    protected boolean hasReadableOutboundBuffer() {
        return !this.lastOutboundBuffer().isEmpty();
    }

    @Override
    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        buf.drainTo((Collection<Object>)((Object)this.lastOutboundBuffer()));
    }
}

