/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class ByteToMessageCodec<I>
extends ChannelDuplexHandler
implements ChannelInboundByteHandler,
ChannelOutboundMessageHandler<I> {
    private final TypeParameterMatcher outboundMsgMatcher;
    private final MessageToByteEncoder<I> encoder = new MessageToByteEncoder<I>(){

        @Override
        public boolean acceptOutboundMessage(Object msg) throws Exception {
            return ByteToMessageCodec.this.acceptOutboundMessage(msg);
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, I msg, ByteBuf out) throws Exception {
            ByteToMessageCodec.this.encode(ctx, msg, out);
        }
    };
    private final ByteToMessageDecoder decoder = new ByteToMessageDecoder(){

        @Override
        public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            return ByteToMessageCodec.this.decode(ctx, in);
        }

        @Override
        protected Object decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            return ByteToMessageCodec.this.decodeLast(ctx, in);
        }
    };

    protected ByteToMessageCodec() {
        this.outboundMsgMatcher = TypeParameterMatcher.find(this, ByteToMessageCodec.class, "I");
    }

    protected ByteToMessageCodec(Class<? extends I> outboundMessageType) {
        this.outboundMsgMatcher = TypeParameterMatcher.get(outboundMessageType);
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.decoder.beforeAdd(ctx);
    }

    @Override
    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.decoder.newInboundBuffer(ctx);
    }

    @Override
    public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        this.decoder.discardInboundReadBytes(ctx);
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.decoder.freeInboundBuffer(ctx);
    }

    @Override
    public MessageBuf<I> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.encoder.newOutboundBuffer(ctx);
    }

    @Override
    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.encoder.freeOutboundBuffer(ctx);
    }

    @Override
    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        this.decoder.inboundBufferUpdated(ctx);
    }

    @Override
    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.encoder.flush(ctx, promise);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.outboundMsgMatcher.match(msg);
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected abstract Object decode(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        return this.decode(ctx, in);
    }
}

