/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketInputStream;
import net.md_5.bungee.plugin.ServerConnectEvent;

public class UserConnection
extends GenericConnection
implements CommandSender {
    public final Packet2Handshake handshake;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    private ServerConnection server;
    private UpstreamBridge upBridge;
    private DownstreamBridge downBridge;
    private int clientEntityId;
    private int serverEntityId;
    private volatile boolean reconnecting;

    public UserConnection(Socket socket, PacketInputStream in, OutputStream out, Packet2Handshake handshake) {
        super(socket, in, out);
        this.handshake = handshake;
        this.username = handshake.username;
        BungeeCord.instance.connections.put(this.username, this);
    }

    public void connect(String server) {
        ServerConnectEvent event = new ServerConnectEvent(this.server == null, this, server);
        event.setNewServer(server);
        BungeeCord.instance.pluginManager.onServerConnect(event);
        if (event.getMessage() != null) {
            this.sendMessage(event.getMessage());
        }
        if (event.getNewServer() == null) {
            if (event.isFirstTime()) {
                event.setNewServer(BungeeCord.instance.config.defaultServerName);
            } else {
                return;
            }
        }
        InetSocketAddress addr = BungeeCord.instance.config.getServer(event.getNewServer());
        this.connect(server, addr);
    }

    private void connect(String name, InetSocketAddress serverAddr) {
        try {
            this.reconnecting = true;
            if (this.server != null) {
                this.out.write(new Packet9Respawn(1, 0, 0, 256, "DEFAULT").getPacket());
                this.out.write(new Packet9Respawn(-1, 0, 0, 256, "DEFAULT").getPacket());
            }
            ServerConnection newServer = ServerConnection.connect(name, serverAddr, this.handshake, this.server == null);
            if (this.server == null) {
                this.clientEntityId = newServer.loginPacket.entityId;
                this.serverEntityId = newServer.loginPacket.entityId;
                this.out.write(newServer.loginPacket.getPacket());
                this.upBridge = new UpstreamBridge();
                this.upBridge.start();
            } else {
                try {
                    this.downBridge.interrupt();
                    this.downBridge.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.server.disconnect("Quitting");
                Packet1Login login = newServer.loginPacket;
                this.serverEntityId = login.entityId;
                this.out.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType).getPacket());
            }
            this.reconnecting = false;
            this.downBridge = new DownstreamBridge();
            this.server = newServer;
            this.downBridge.start();
        }
        catch (KickException ex) {
            this.destroySelf(ex.getMessage());
        }
        catch (Exception ex) {
            this.destroySelf("Could not connect to server");
        }
    }

    public SocketAddress getAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    private void destroySelf(String reason) {
        if (BungeeCord.instance.isRunning) {
            BungeeCord.instance.connections.remove(this.username);
        }
        this.disconnect(reason);
        if (this.server != null) {
            this.server.disconnect("Quitting");
            BungeeCord.instance.config.setServer(this, this.server.name);
        }
    }

    @Override
    public void sendMessage(String message) {
        this.packetQueue.add(new Packet3Chat(message));
    }

    @Override
    public String getName() {
        return this.username;
    }

    private class DownstreamBridge
    extends Thread {
        public DownstreamBridge() {
            super("Downstream Bridge - " + UserConnection.this.username);
        }

        @Override
        public void run() {
            try {
                while (!UserConnection.this.reconnecting) {
                    byte[] packet = ((UserConnection)UserConnection.this).server.in.readPacket();
                    int id = Util.getId(packet);
                    if (id == 250) {
                        PacketFAPluginMessage message = new PacketFAPluginMessage(packet);
                        if (message.tag.equals("RubberBand")) {
                            String server = new String(message.data);
                            UserConnection.this.connect(server);
                            break;
                        }
                    }
                    while (!UserConnection.this.packetQueue.isEmpty()) {
                        DefinedPacket p = UserConnection.this.packetQueue.poll();
                        if (p == null) continue;
                        UserConnection.this.out.write(p.getPacket());
                    }
                    EntityMap.rewrite(packet, UserConnection.this.serverEntityId, UserConnection.this.clientEntityId);
                    UserConnection.this.out.write(packet);
                }
            }
            catch (Exception ex) {
                UserConnection.this.destroySelf(Util.exception(ex));
            }
        }
    }

    private class UpstreamBridge
    extends Thread {
        public UpstreamBridge() {
            super("Upstream Bridge - " + UserConnection.this.username);
        }

        @Override
        public void run() {
            while (!UserConnection.this.socket.isClosed()) {
                try {
                    byte[] packet = UserConnection.this.in.readPacket();
                    boolean sendPacket = true;
                    int id = Util.getId(packet);
                    if (id == 3) {
                        Packet3Chat chat = new Packet3Chat(packet);
                        String message = chat.message;
                        if (message.startsWith("/")) {
                            sendPacket = !BungeeCord.instance.dispatchCommand(message.substring(1), UserConnection.this);
                        }
                    }
                    EntityMap.rewrite(packet, UserConnection.this.clientEntityId, UserConnection.this.serverEntityId);
                    if (!sendPacket || ((UserConnection)UserConnection.this).server.socket.isClosed()) continue;
                    ((UserConnection)UserConnection.this).server.out.write(packet);
                }
                catch (IOException ex) {
                    UserConnection.this.destroySelf("Reached end of stream");
                }
                catch (Exception ex) {
                    UserConnection.this.destroySelf(Util.exception(ex));
                }
            }
        }
    }
}

