/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected SimpleChannelInboundHandler() {
        this.matcher = TypeParameterMatcher.find(this, SimpleChannelInboundHandler.class, "I");
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList<Object> unaccepted = MessageList.newInstance();
        int size = msgs.size();
        try {
            for (int i = 0; i < size; ++i) {
                Object msg = msgs.get(i);
                if (!ctx.isRemoved() && this.acceptInboundMessage(msg)) {
                    if (!unaccepted.isEmpty()) {
                        ctx.fireMessageReceived(unaccepted);
                        unaccepted = MessageList.newInstance();
                    }
                    Object imsg = msg;
                    this.messageReceived(ctx, imsg);
                    continue;
                }
                unaccepted.add(msg);
            }
        }
        finally {
            msgs.recycle();
            ctx.fireMessageReceived(unaccepted);
        }
    }

    protected abstract void messageReceived(ChannelHandlerContext var1, I var2) throws Exception;
}

