/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.command.CommandAlert;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandFind;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandList;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.CommandSend;
import net.md_5.bungee.command.CommandServer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.YamlConfig;
import net.md_5.bungee.log.BungeeLogger;
import net.md_5.bungee.log.LoggingOutputStream;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.packet.DefinedPacket;
import net.md_5.bungee.protocol.packet.Packet3Chat;
import net.md_5.bungee.protocol.packet.PacketFAPluginMessage;
import net.md_5.bungee.reconnect.SQLReconnectHandler;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.scheduler.BungeeThreadPool;
import net.md_5.bungee.util.CaseInsensitiveMap;

public class BungeeCord
extends ProxyServer {
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public final ResourceBundle bundle = ResourceBundle.getBundle("messages_en");
    public final ScheduledThreadPoolExecutor executors = new BungeeThreadPool(new ThreadFactoryBuilder().setNameFormat("Bungee Pool Thread #%1$d").build());
    public final MultithreadEventLoopGroup eventLoops = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty IO Thread #%1$d").build());
    private final Timer saveThread = new Timer("Reconnect Saver");
    private final Timer metricsThread = new Timer("Metrics Thread");
    private Collection<Channel> listeners = new HashSet<Channel>();
    private final Map<String, UserConnection> connections = new CaseInsensitiveMap<UserConnection>();
    private final ReadWriteLock connectionLock = new ReentrantReadWriteLock();
    public final PluginManager pluginManager = new PluginManager(this);
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final TaskScheduler scheduler = new BungeeScheduler();
    private final AsyncHttpClient httpClient = new AsyncHttpClient(new NettyAsyncHttpProvider(new AsyncHttpClientConfig.Builder().setAsyncHttpClientProviderConfig(new NettyAsyncHttpProviderConfig().addProperty("bossExecutorService", (Object)this.executors)).setExecutorService(this.executors).build()));
    private final ConsoleReader consoleReader;
    private final Logger logger;

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public BungeeCord() throws IOException {
        this.getPluginManager().registerCommand(null, new CommandReload());
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandList());
        this.getPluginManager().registerCommand(null, new CommandServer());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandAlert());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        this.getPluginManager().registerCommand(null, new CommandSend());
        this.getPluginManager().registerCommand(null, new CommandFind());
        this.registerChannel("BungeeCord");
        this.consoleReader = new ConsoleReader();
        Runtime.getRuntime().addShutdownHook(new Thread("JLine Cleanup Thread"){

            @Override
            public void run() {
                try {
                    BungeeCord.this.consoleReader.getTerminal().restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.logger = new BungeeLogger(this);
        System.setErr(new PrintStream(new LoggingOutputStream(this.logger, Level.SEVERE), true));
        System.setOut(new PrintStream(new LoggingOutputStream(this.logger, Level.INFO), true));
    }

    public static void main(String[] args) throws Exception {
        Calendar deadline = Calendar.getInstance();
        deadline.set(2013, 7, 1);
        if (Calendar.getInstance().after(deadline)) {
            System.err.println("*** Warning, this build is outdated ***");
            System.err.println("*** Please download a new build from http://ci.md-5.net/job/BungeeCord ***");
            System.err.println("*** You will get NO support regarding this build ***");
            System.err.println("*** Server will start in 15 seconds ***");
            Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
        }
        BungeeCord bungee = new BungeeCord();
        ProxyServer.setInstance(bungee);
        bungee.getLogger().info("Enabled BungeeCord version " + bungee.getVersion());
        bungee.start();
        while (bungee.isRunning) {
            String line = bungee.getConsoleReader().readLine(">");
            if (line == null || bungee.getPluginManager().dispatchCommand(ConsoleCommandSender.getInstance(), line)) continue;
            bungee.getConsole().sendMessage((Object)((Object)ChatColor.RED) + "Command not found");
        }
    }

    @Override
    public void start() throws Exception {
        this.pluginsFolder.mkdir();
        this.pluginManager.detectPlugins(this.pluginsFolder);
        this.config.load();
        if (this.reconnectHandler == null) {
            this.reconnectHandler = new SQLReconnectHandler();
        }
        this.isRunning = true;
        this.pluginManager.loadAndEnablePlugins();
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BungeeCord.this.getReconnectHandler().save();
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        this.metricsThread.scheduleAtFixedRate((TimerTask)new Metrics(), 0L, TimeUnit.MINUTES.toMillis(10L));
    }

    public void startListeners() {
        for (final ListenerInfo info : this.config.getListeners()) {
            ChannelFutureListener listener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Listening on " + info.getHost());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getHost(), future.cause());
                    }
                }
            };
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).childAttr(PipelineUtils.LISTENER, info).childHandler(PipelineUtils.SERVER_CHILD).group(this.eventLoops).localAddress(info.getHost())).bind().addListener(listener);
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        new Thread("Shutdown Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BungeeCord.this.isRunning = false;
                BungeeCord.this.httpClient.close();
                BungeeCord.this.executors.shutdown();
                BungeeCord.this.stopListeners();
                BungeeCord.this.getLogger().info("Closing pending connections");
                BungeeCord.this.connectionLock.readLock().lock();
                try {
                    BungeeCord.this.getLogger().info("Disconnecting " + BungeeCord.this.connections.size() + " connections");
                    for (UserConnection user : BungeeCord.this.connections.values()) {
                        user.disconnect(BungeeCord.this.getTranslation("restart"));
                    }
                }
                finally {
                    BungeeCord.this.connectionLock.readLock().unlock();
                }
                BungeeCord.this.getLogger().info("Closing IO threads");
                BungeeCord.this.eventLoops.shutdown();
                try {
                    BungeeCord.this.eventLoops.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                BungeeCord.this.getLogger().info("Saving reconnect locations");
                BungeeCord.this.reconnectHandler.save();
                BungeeCord.this.reconnectHandler.close();
                BungeeCord.this.saveThread.cancel();
                BungeeCord.this.metricsThread.cancel();
                BungeeCord.this.getLogger().info("Disabling plugins");
                for (Plugin plugin : BungeeCord.this.pluginManager.getPlugins()) {
                    plugin.onDisable();
                    BungeeCord.this.getScheduler().cancel(plugin);
                }
                BungeeCord.this.getLogger().info("Thankyou and goodbye");
                System.exit(0);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DefinedPacket packet) {
        this.connectionLock.readLock().lock();
        try {
            for (UserConnection con : this.connections.values()) {
                con.unsafe().sendPacket(packet);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "BungeeCord";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getTranslation(String name) {
        String translation = "<translation '" + name + "' missing>";
        try {
            translation = this.bundle.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        this.connectionLock.readLock().lock();
        try {
            HashSet<ProxiedPlayer> hashSet = new HashSet<ProxiedPlayer>(this.connections.values());
            return hashSet;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public int getOnlineCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxiedPlayer getPlayer(String name) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connections.get(name);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PacketFAPluginMessage registerChannels() {
        return new PacketFAPluginMessage("REGISTER", Util.format(this.pluginChannels, "\u0000").getBytes());
    }

    @Override
    public byte getProtocolVersion() {
        return 61;
    }

    @Override
    public String getGameVersion() {
        return "1.5.2";
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, boolean restricted) {
        return new BungeeServerInfo(name, address, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public void broadcast(String message) {
        this.getConsole().sendMessage(message);
        this.broadcast(new Packet3Chat(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.put(con.getName(), con);
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.remove(con.getName());
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

