/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.config.TexturePackInfo;
import net.md_5.bungee.api.tab.TabListHandler;
import net.md_5.bungee.tablist.Global;
import net.md_5.bungee.tablist.GlobalPing;
import net.md_5.bungee.tablist.ServerUnique;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig
implements ConfigurationAdapter {
    private Yaml yaml;
    private Map config;
    private final File file = new File("config.yml");

    @Override
    public void load() {
        Map groups;
        try {
            this.file.createNewFile();
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            try (FileInputStream is = new FileInputStream(this.file);){
                this.config = (Map)this.yaml.load(is);
            }
            this.config = this.config == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(this.config);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load configuration!", ex);
        }
        Map permissions = this.get("permissions", new HashMap());
        if (permissions.isEmpty()) {
            permissions.put("default", Arrays.asList("bungeecord.command.server", "bungeecord.command.list"));
            permissions.put("admin", Arrays.asList("bungeecord.command.alert", "bungeecord.command.end", "bungeecord.command.ip", "bungeecord.command.reload"));
        }
        if ((groups = (Map)this.get("groups", new HashMap())).isEmpty()) {
            groups.put("md_5", Collections.singletonList("admin"));
        }
    }

    private <T> T get(String path, T def) {
        return this.get(path, def, this.config);
    }

    private <T> T get(String path, T def, Map submap) {
        int index = path.indexOf(46);
        if (index == -1) {
            Object val = submap.get(path);
            if (val == null && def != null) {
                val = def;
                submap.put(path, def);
                this.save();
            }
            return (T)val;
        }
        String first = path.substring(0, index);
        String second = path.substring(index + 1, path.length());
        LinkedHashMap sub = (LinkedHashMap)submap.get(first);
        if (sub == null) {
            sub = new LinkedHashMap();
            submap.put(first, sub);
        }
        return this.get(second, def, sub);
    }

    private void save() {
        try (FileWriter wr = new FileWriter(this.file);){
            this.yaml.dump(this.config, wr);
        }
        catch (IOException ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not save config", ex);
        }
    }

    @Override
    public int getInt(String path, int def) {
        return this.get(path, def);
    }

    @Override
    public String getString(String path, String def) {
        return this.get(path, def);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.get(path, def);
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        Map base = this.get("servers", Collections.singletonMap("lobby", new HashMap()));
        HashMap<String, ServerInfo> ret = new HashMap<String, ServerInfo>();
        for (Map.Entry entry : base.entrySet()) {
            Map val = entry.getValue();
            String name = entry.getKey();
            String addr = this.get("address", "localhost:25565", val);
            boolean restricted = this.get("restricted", false, val);
            InetSocketAddress address = Util.getAddr(addr);
            ServerInfo info = ProxyServer.getInstance().constructServerInfo(name, address, restricted);
            ret.put(name, info);
        }
        return ret;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        Collection base = this.get("listeners", Arrays.asList(new HashMap()));
        HashMap<String, String> forcedDef = new HashMap<String, String>();
        forcedDef.put("pvp.md-5.net", "pvp");
        HashSet<ListenerInfo> ret = new HashSet<ListenerInfo>();
        for (Map val : base) {
            String motd = this.get("motd", "Another Bungee server", val);
            motd = ChatColor.translateAlternateColorCodes('&', motd);
            int maxPlayers = this.get("max_players", 1, val);
            String defaultServer = this.get("default_server", "lobby", val);
            String fallbackServer = this.get("fallback_server", defaultServer, val);
            boolean forceDefault = this.get("force_default_server", false, val);
            String host = this.get("host", "0.0.0.0:25577", val);
            int tabListSize = this.get("tab_size", 60, val);
            InetSocketAddress address = Util.getAddr(host);
            CaseInsensitiveMap<String> forced = new CaseInsensitiveMap<String>(this.get("forced_hosts", forcedDef, val));
            String textureURL = this.get("texture_url", null, val);
            int textureSize = this.get("texture_size", 16, val);
            TexturePackInfo texture = textureURL == null ? null : new TexturePackInfo(textureURL, textureSize);
            String tabListName = this.get("tab_list", "GLOBAL_PING", val);
            DefaultTabList value = DefaultTabList.valueOf(tabListName.toUpperCase());
            if (value == null) {
                value = DefaultTabList.GLOBAL_PING;
            }
            ListenerInfo info = new ListenerInfo(address, motd, maxPlayers, tabListSize, defaultServer, fallbackServer, forceDefault, forced, texture, value.clazz);
            ret.add(info);
        }
        return ret;
    }

    @Override
    public Collection<String> getGroups(String player) {
        Collection groups = this.get("groups." + player, null);
        HashSet<String> ret = groups == null ? new HashSet<String>() : new HashSet(groups);
        ret.add("default");
        return ret;
    }

    @Override
    public Collection<String> getPermissions(String group) {
        return this.get("permissions." + group, Collections.EMPTY_LIST);
    }

    private static enum DefaultTabList {
        GLOBAL(Global.class),
        GLOBAL_PING(GlobalPing.class),
        SERVER(ServerUnique.class);

        private final Class<? extends TabListHandler> clazz;

        private DefaultTabList(Class<? extends TabListHandler> clazz) {
            this.clazz = clazz;
        }
    }
}

