/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tablist;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.tab.TabAPI;
import net.md_5.bungee.api.tab.TabListAdapter;
import net.md_5.bungee.protocol.packet.PacketC9PlayerListItem;

public class Custom
extends TabListAdapter
implements TabAPI {
    private static final int ROWS = 20;
    private static final int COLUMNS = 3;
    private final Collection<String> sentStuff = new HashSet<String>();
    private String[][] sent = new String[20][3];
    private String[][] pending = new String[20][3];

    @Override
    public synchronized void setSlot(int row, int column, String text) {
        this.setSlot(row, column, text, true);
    }

    @Override
    public synchronized void setSlot(int row, int column, String text, boolean update) {
        Preconditions.checkArgument(row >= 0 && row < 20, "row out of range");
        Preconditions.checkArgument(column >= 0 && column < 3, "column out of range");
        Preconditions.checkNotNull(text, "text");
        Preconditions.checkArgument(text.length() <= 16, "text must be <= 16 chars");
        Preconditions.checkArgument(!this.sentStuff.contains(text), "list already contains %s", text);
        Preconditions.checkArgument(!ChatColor.stripColor(text).equals(text), "Text cannot consist entirely of colour codes");
        this.pending[20][3] = text;
        if (update) {
            this.update();
        }
    }

    @Override
    public synchronized void update() {
        this.clear();
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 3; ++j) {
                String text;
                if (this.pending[i][j] != null) {
                    text = this.pending[i][j];
                    this.sentStuff.add(text);
                } else {
                    text = "" + '\u00a7' + Custom.base(i) + '\u00a7' + Custom.base(j);
                }
                this.getPlayer().unsafe().sendPacket(new PacketC9PlayerListItem(text, true, 0));
                this.sent[i][j] = text;
                this.pending[i][j] = null;
            }
        }
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.getPlayer().unsafe().sendPacket(new PacketC9PlayerListItem(this.sent[i][j], false, 9999));
            }
        }
        this.sent = new String[20][3];
        this.sentStuff.clear();
    }

    @Override
    public synchronized int getRows() {
        return 20;
    }

    @Override
    public synchronized int getColumns() {
        return 3;
    }

    @Override
    public synchronized int getSize() {
        return 60;
    }

    @Override
    public boolean onListUpdate(String name, boolean online, int ping) {
        return false;
    }

    private static char[] base(int n) {
        String hex = Integer.toHexString(n);
        char[] alloc = new char[hex.length() * 2];
        for (int i = 0; i < alloc.length; ++i) {
            alloc[i] = i % 2 == 0 ? 167 : hex.charAt(i / 2);
        }
        return alloc;
    }
}

