/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.beans.ConstructorProperties;
import net.md_5.bungee.netty.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketDecoder
extends ReplayingDecoder<Void> {
    private Protocol protocol;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, MessageBuf<Object> out) throws Exception {
        while (true) {
            int startIndex = in.readerIndex();
            DefinedPacket packet = this.protocol.read(in.readUnsignedByte(), in);
            int endIndex = in.readerIndex();
            byte[] buf = new byte[endIndex - startIndex];
            in.readerIndex(startIndex);
            in.readBytes(buf, 0, buf.length);
            in.readerIndex(endIndex);
            this.checkpoint();
            if (packet != null) {
                out.add(new PacketWrapper(packet, buf));
                continue;
            }
            out.add(buf);
        }
    }

    @ConstructorProperties(value={"protocol"})
    public PacketDecoder(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }
}

