/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import java.beans.ConstructorProperties;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class PingHandler
extends PacketHandler {
    private final ServerInfo target;
    private final Callback<ServerPing> callback;
    private static final byte[] pingBuf = new byte[]{-2, 1};

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        channel.write(pingBuf);
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.callback.done(null, t);
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        String[] split = kick.message.split("\u0000");
        ServerPing ping = new ServerPing(Byte.parseByte(split[1]), split[2], split[3], Integer.parseInt(split[4]), Integer.parseInt(split[5]));
        this.callback.done(ping, null);
    }

    @Override
    public String toString() {
        return "[Ping Handler] -> " + this.target.getName();
    }

    @ConstructorProperties(value={"target", "callback"})
    public PingHandler(ServerInfo target, Callback<ServerPing> callback) {
        this.target = target;
        this.callback = callback;
    }
}

