/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Body;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.stream.ChunkedInput;

class BodyChunkedInput
implements ChunkedInput {
    private final Body body;
    private final int chunkSize = 8192;
    private ByteBuffer nextChunk;
    private static final ByteBuffer EOF = ByteBuffer.allocate(0);

    public BodyChunkedInput(Body body) {
        if (body == null) {
            throw new IllegalArgumentException("no body specified");
        }
        this.body = body;
    }

    private ByteBuffer peekNextChuck() throws IOException {
        if (this.nextChunk == null) {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            if (this.body.read(buffer) < 0L) {
                this.nextChunk = EOF;
            } else {
                buffer.flip();
                this.nextChunk = buffer;
            }
        }
        return this.nextChunk;
    }

    public boolean hasNextChunk() throws Exception {
        return !this.isEndOfInput();
    }

    public Object nextChunk() throws Exception {
        ByteBuffer buffer = this.peekNextChuck();
        if (buffer == EOF) {
            return null;
        }
        this.nextChunk = null;
        return ChannelBuffers.wrappedBuffer(buffer);
    }

    public boolean isEndOfInput() throws Exception {
        return this.peekNextChuck() == EOF;
    }

    public void close() throws Exception {
        this.body.close();
    }
}

