/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentStringsMap
implements Map<String, List<String>>,
Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();

    public FluentStringsMap() {
    }

    public FluentStringsMap(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
    }

    public FluentStringsMap(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
    }

    public FluentStringsMap add(String key, String ... values) {
        if (MiscUtil.isNonEmpty(values)) {
            this.add(key, Arrays.asList(values));
        }
        return this;
    }

    private List<String> fetchValues(Collection<String> values) {
        ArrayList<String> result = null;
        if (values != null) {
            for (String value : values) {
                if (value == null) {
                    value = "";
                }
                if (result == null) {
                    result = new ArrayList<String>();
                }
                result.add(value);
            }
        }
        return result;
    }

    public FluentStringsMap add(String key, Collection<String> values) {
        List<String> nonNullValues;
        if (key != null && (nonNullValues = this.fetchValues(values)) != null) {
            List<String> curValues = this.values.get(key);
            if (curValues == null) {
                curValues = new ArrayList<String>();
                this.values.put(key, curValues);
            }
            curValues.addAll(nonNullValues);
        }
        return this;
    }

    public FluentStringsMap addAll(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.add(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public FluentStringsMap addAll(Map<String, Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<String, Collection<String>> header : src.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    @Override
    public FluentStringsMap replace(String key, String ... values) {
        return this.replace(key, (Collection<String>)Arrays.asList(values));
    }

    @Override
    public FluentStringsMap replace(String key, Collection<String> values) {
        if (key != null) {
            List<String> nonNullValues = this.fetchValues(values);
            if (nonNullValues == null) {
                this.values.remove(key);
            } else {
                this.values.put(key, nonNullValues);
            }
        }
        return this;
    }

    public FluentStringsMap replaceAll(FluentStringsMap src) {
        if (src != null) {
            for (Map.Entry<String, List<String>> header : src) {
                this.replace(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        return this;
    }

    public FluentStringsMap replaceAll(Map<? extends String, ? extends Collection<String>> src) {
        if (src != null) {
            for (Map.Entry<? extends String, ? extends Collection<String>> header : src.entrySet()) {
                this.replace(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    @Override
    public List<String> put(String key, List<String> value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Object oldValue = this.get(key);
        this.replace(key, (Collection<String>)value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> values) {
        this.replaceAll(values);
    }

    public FluentStringsMap delete(String key) {
        this.values.remove(key);
        return this;
    }

    public FluentStringsMap deleteAll(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                this.remove(key);
            }
        }
        return this;
    }

    public FluentStringsMap deleteAll(Collection<String> keys) {
        if (keys != null) {
            for (String key : keys) {
                this.remove(key);
            }
        }
        return this;
    }

    @Override
    public List<String> remove(Object key) {
        if (key == null) {
            return null;
        }
        Object oldValues = this.get(key.toString());
        this.delete(key.toString());
        return oldValues;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return Collections.unmodifiableSet(this.values.entrySet()).iterator();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key == null ? false : this.values.containsKey(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    public String getFirstValue(String key) {
        Object values = this.get(key);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return "";
        }
        return (String)values.get(0);
    }

    public String getJoinedValue(String key, String delimiter) {
        Object values = this.get(key);
        if (values == null) {
            return null;
        }
        if (values.size() == 1) {
            return (String)values.get(0);
        }
        StringBuilder result = new StringBuilder();
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            String value = (String)i$.next();
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(value);
        }
        return result.toString();
    }

    @Override
    public List<String> get(Object key) {
        if (key == null) {
            return null;
        }
        return this.values.get(key.toString());
    }

    @Override
    public Collection<List<String>> values() {
        return this.values.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluentStringsMap other = (FluentStringsMap)obj;
        return !(this.values == null ? other.values != null : !((Object)this.values).equals(other.values));
    }

    @Override
    public int hashCode() {
        return this.values == null ? 0 : ((Object)this.values).hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append("\"");
            result.append(entry.getKey());
            result.append("=");
            boolean needsComma = false;
            for (String value : entry.getValue()) {
                if (needsComma) {
                    result.append(", ");
                } else {
                    needsComma = true;
                }
                result.append(value);
            }
            result.append("\"");
        }
        return result.toString();
    }
}

