/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.beans.ConstructorProperties;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Queue;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.scoreboard.Objective;
import net.md_5.bungee.api.scoreboard.Scoreboard;
import net.md_5.bungee.api.scoreboard.Team;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.CipherDecoder;
import net.md_5.bungee.netty.CipherEncoder;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketDecoder;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketCEScoreboardObjective;
import net.md_5.bungee.packet.PacketD1Team;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.ENCRYPT_REQUEST;
    private SecretKey secretkey;
    private boolean sentMessages;

    @Override
    public void exception(Throwable t) throws Exception {
        String message = "Exception Connectiong:" + Util.exception(t);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage((Object)((Object)ChatColor.RED) + message);
        }
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Login");
        out.writeUTF(this.user.getAddress().getAddress().getHostAddress());
        out.writeInt(this.user.getAddress().getPort());
        channel.write(new PacketFAPluginMessage("BungeeCord", out.toByteArray()));
        channel.write(this.user.getPendingConnection().getHandshake());
        if (this.user.getPendingConnection().getForgeLogin() == null) {
            channel.write(PacketCDClientStatus.CLIENT_LOGIN);
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Packet1Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not exepcting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target);
        ServerConnectedEvent event = new ServerConnectedEvent(this.user, server);
        this.bungee.getPluginManager().callEvent(event);
        this.ch.write(BungeeCord.getInstance().registerChannels());
        Queue<DefinedPacket> packetQueue = this.target.getPacketQueue();
        Object object = packetQueue;
        synchronized (object) {
            while (!packetQueue.isEmpty()) {
                this.ch.write(packetQueue.poll());
            }
        }
        if (!this.sentMessages) {
            for (PacketFAPluginMessage message : this.user.getPendingConnection().getLoginMessages()) {
                this.ch.write(message);
            }
        }
        if (this.user.getSettings() != null) {
            this.ch.write(this.user.getSettings());
        }
        object = this.user.getSwitchMutex();
        synchronized (object) {
            if (this.user.getServer() == null) {
                this.user.setClientEntityId(login.entityId);
                this.user.setServerEntityId(login.entityId);
                Packet1Login modLogin = new Packet1Login(login.entityId, login.levelType, login.gameMode, (byte)login.dimension, login.difficulty, login.unused, (byte)this.user.getPendingConnection().getListener().getTabListSize(), this.ch.getHandle().pipeline().get(PacketDecoder.class).getProtocol() == 256);
                this.user.sendPacket(modLogin);
            } else {
                this.bungee.getTabListHandler().onServerChange(this.user);
                Scoreboard serverScoreboard = this.user.getServerSentScoreboard();
                for (Objective objective : serverScoreboard.getObjectives()) {
                    this.user.sendPacket(new PacketCEScoreboardObjective(objective.getName(), objective.getValue(), 1));
                }
                for (Team team : serverScoreboard.getTeams()) {
                    this.user.sendPacket(PacketD1Team.destroy(team.getName()));
                }
                serverScoreboard.clear();
                this.user.sendPacket(Packet9Respawn.DIM1_SWITCH);
                this.user.sendPacket(Packet9Respawn.DIM2_SWITCH);
                this.user.setServerEntityId(login.entityId);
                this.user.sendPacket(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType));
                this.user.getServer().setObsolete(true);
                this.user.getServer().disconnect("Quitting");
            }
            if (!this.user.isActive()) {
                server.disconnect("Quitting");
                this.bungee.getLogger().warning("No client connected for pending server!");
                return;
            }
            this.target.addPlayer(this.user);
            this.user.getPendingConnects().remove(this.target);
            this.user.setServer(server);
            this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(this.bungee, this.user, server));
        }
        this.bungee.getPluginManager().callEvent(new ServerSwitchEvent(this.user));
        this.thisState = State.FINISHED;
        throw new CancelSendSignal();
    }

    @Override
    public void handle(PacketFDEncryptionRequest encryptRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT_REQUEST, "Not expecting ENCRYPT_REQUEST");
        if (this.user.getPendingConnection().getForgeLogin() != null) {
            PublicKey publickey = EncryptionUtil.getPubkey(encryptRequest);
            this.secretkey = EncryptionUtil.getSecret();
            byte[] shared = EncryptionUtil.encrypt(publickey, this.secretkey.getEncoded());
            byte[] token = EncryptionUtil.encrypt(publickey, encryptRequest.verifyToken);
            this.ch.write(new PacketFCEncryptionResponse(shared, token));
            Cipher encrypt = EncryptionUtil.getCipher(1, this.secretkey);
            this.ch.getHandle().pipeline().addBefore("decoder", "encrypt", new CipherEncoder(encrypt));
            this.thisState = State.ENCRYPT_RESPONSE;
        } else {
            this.thisState = State.LOGIN;
        }
    }

    @Override
    public void handle(PacketFCEncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT_RESPONSE, "Not expecting ENCRYPT_RESPONSE");
        Cipher decrypt = EncryptionUtil.getCipher(2, this.secretkey);
        this.ch.getHandle().pipeline().addBefore("decoder", "decrypt", new CipherDecoder(decrypt));
        this.ch.write(this.user.getPendingConnection().getForgeLogin());
        this.ch.write(PacketCDClientStatus.CLIENT_LOGIN);
        this.thisState = State.LOGIN;
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.user.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.target, def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.user, kick.message, def))).isCancelled() && event.getCancelServer() != null) {
            this.user.connect(event.getCancelServer());
            return;
        }
        String message = this.bungee.getTranslation("connect_kick") + this.target.getName() + ": " + kick.message;
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        if ((pluginMessage.data[0] & 0xFF) == 0 && pluginMessage.tag.equals("FML")) {
            ByteArrayDataInput in = ByteStreams.newDataInput(pluginMessage.data);
            in.readUnsignedByte();
            for (int i = 0; i < in.readInt(); ++i) {
                in.readUTF();
            }
            if (in.readByte() != 0) {
                this.ch.getHandle().pipeline().get(PacketDecoder.class).setProtocol(256);
            }
        }
        this.user.sendPacket(pluginMessage);
        if (!this.sentMessages && this.user.getPendingConnection().getForgeLogin() != null) {
            for (PacketFAPluginMessage message : this.user.getPendingConnection().getLoginMessages()) {
                this.ch.write(message);
            }
            this.sentMessages = true;
        }
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "user", "target"})
    public ServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    private static enum State {
        ENCRYPT_REQUEST,
        ENCRYPT_RESPONSE,
        LOGIN,
        FINISHED;

    }
}

